// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.pica.cloud.account.account.server.service.ThreadPoolService;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import com.pica.cloud.riskcontrol.riskcontrol.client.CheckCodeClient;
import com.pica.cloud.riskcontrol.riskcontrol.common.req.CheckcodeRiskReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

/**
 * @ClassName ThreadPoolServiceImpl
 * @Description
 * @Author Chongwen.jiang
 * @Date 2020/4/22 17:51
 * @ModifyDate 2020/4/22 17:51
 * @Version 1.0
 */
@Service
public class ThreadPoolServiceImpl implements ThreadPoolService {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolServiceImpl.class);

    @Autowired
    @Qualifier("accountThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private CheckCodeClient rcClient;


    @Override
    public void recordRcData(Integer sourceType, String mobile, String ip,
                             String deviceToken, String deviceIp) {
        CheckcodeRiskReq rec = new CheckcodeRiskReq();
        rec.setSourceType(sourceType);
        rec.setMobile(mobile);
        rec.setIp(ip);
        if(!StringUtil.isEmpty(deviceToken)) {
            rec.setDeviceId(deviceToken);
        }
        if(!StringUtil.isEmpty(deviceIp)) {
            rec.setDeviceIp(deviceIp);
        }

        try {
            threadPoolTaskExecutor.execute(() -> {
                logger.info("recordRcData-execute-{}", JSON.toJSONString(rec));
                PicaResponse resp = rcClient.logSend(rec);
                logger.info("recordRcData-resp-{}", JSON.toJSONString(resp));
            });
        } catch (Exception e) {
            logger.error("recordRcData invoke error", e.getMessage());
        }
    }

}
