package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.constants.Constants;
import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.entity.LoginResult;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.req.AccountReq;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.AccountService;
import com.pica.cloud.account.account.server.service.CaptchaService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.account.account.server.util.IntactUtil;
import com.pica.cloud.foundation.completeness.client.utils.IntactUtils;
import com.pica.cloud.foundation.encryption.common.constants.EncryptConstants;
import com.pica.cloud.foundation.encryption.util.EncryptUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.constants.CommonConstants;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.foundation.utils.utils.CommonUtil;
import com.pica.cloud.foundation.utils.utils.ValidateUtils;
import com.pica.cloud.foundation.utils.utils.json.Object2Map;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.Map;
import java.util.UUID;

/**
 * 账号相关controller
 *
 * @author andong
 * @create 2019/5/20
 */
@Api(description = "账号管理")
@RestController
@RequestMapping("/account")
public class AccountController extends AccountBaseController {
    private Logger logger = LoggerFactory.getLogger(AccountController.class);

    @Autowired
    private AccountService accountService;
    @Autowired
    private CaptchaService captchaService;
    @Autowired
    private ICacheClient redisClient;
    @Autowired
    private AccountUtils accountUtils;
    @Autowired
    private IntactUtil intactUtil;

    @GetMapping("/test")
    public String test() {
        return "{\"status\":\"UP\"}";
    }

    @ApiOperation("获取登录验证码（已无人调用）")
    @GetMapping("/authCode")
    public PicaResponse<String> getAuthCode(@ApiParam(value = "手机号", required = true) @RequestParam("mobilePhone") String mobilePhone,
                                            @ApiParam(value = "验证码类型 0默认 1注册 2修改密码 4微信登录绑定手机 5修改手机 6重置密码 7患者招募提交问卷(效验") @RequestParam(value = "flag", defaultValue = "0") String flag,
                                            @ApiParam(value = "图形验证码token", required = true) @RequestParam("captchaToken") String captchaToken,
                                            @ApiParam(value = "图形验证码答案", required = true) @RequestParam("captchaAnswer") String captchaAnswer) {
        //校验图形验证码
        if (!captchaService.acknowledge(captchaToken, captchaAnswer)) {
            return PicaResponse.toResponse(null, PicaResultCode.PARAM_IS_INVALID.code(), "图形验证码错误");
        }
        this.checkMobilePhone(mobilePhone);
        String authCode = CommonUtil.createValidateCode();  //随机生成验证码
        String message = "您的验证码是" + authCode + ",在10分钟内有效。如非本人操作，请忽略本短信！";
        long senderId = 0L;
        if (Integer.parseInt(flag) != 7) {
            //判断账号是否已经存在
            Account account = accountService.getByMobilePhone(mobilePhone);
            senderId = account == null ? 0L : account.getId();
        }
        //验证码保存到redis，失效时间10分钟
        redisClient.set(this.getAuthCodeKey(mobilePhone, flag), authCode, 600);
        //发送短信
        super.sendMobileMessage(mobilePhone, message, senderId);
        return PicaResponse.toResponse(StringUtils.EMPTY);
    }

    @ApiOperation("教培项目校验短信验证码")
    @GetMapping("/check/authCode")
    public PicaResponse checkAuthCode(@ApiParam(value = "手机号", required = true) @RequestParam("mobilePhone") String mobilePhone,
                                              @ApiParam(value = "验证码类型 0默认 1注册 2修改密码 4微信登录绑定手机 5修改手机 6重置密码 7患者招募提交问卷(效验") @RequestParam(value = "flag", defaultValue = "0") String flag,
                                              @ApiParam(value = "短信验证码", required = true) @RequestParam("authCode") String authCode) {
        this.checkMobilePhone(mobilePhone);
        AccountReq accountReq = new AccountReq();
        accountReq.setMobilePhone(mobilePhone);
        accountReq.setFlag(flag);
        accountReq.setAuthCode(authCode);
        this.checkAuthCode(accountReq);
        return PicaResponse.toResponse();
    }


    @ApiOperation("微信登录")
    @PostMapping("/login/wechat")
    public PicaResponse<String> wechatLogin(@RequestBody AccountReq req) {
        logger.info("wechatLogin:{}",JSONObject.toJSONString(req));
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo,"wechatLogin",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1,"req:"+ JSON.toJSONString(req));
        if (StringUtils.isBlank(req.getUnionid())) {
            intactUtil.sendIntact(batchNo,"wechatLogin",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"确认unionId");
            return PicaResponse.toResponse(null, PicaResultCode.PARAM_IS_INVALID.code(), "缺少unionid");
        }

        Account account = accountService.getByUnionid(req.getUnionid());  //获取账号信息
        if (account == null) {
            intactUtil.sendIntact(batchNo,"wechatLogin",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"该unionid未绑定云鹊医账号");
            return PicaResponse.toResponse(null, PicaResultCode.RESULE_DATA_NONE.code(), "该unionid未绑定云鹊医账号");
        }

        //已经绑定过云鹊医账号，登录成功，返回token
        String deviceType = super.getDeviceInfo("device_type");  //1:pc 2:android 3:ios
        String newToken = this.generateToken(account, deviceType);
        intactUtil.sendIntact(batchNo,"wechatLogin",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"req:"+ JSON.toJSONString(req));

        return PicaResponse.toResponse(newToken);
    }

    @ApiOperation("密码或验证码登录")
    @PostMapping("/login")
    public PicaResponse<String> login(@RequestBody AccountReq req) {
        this.checkMobilePhone(req.getMobilePhone());
        logger.info("login:{}", JSONObject.toJSONString(req));
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo,"login",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1,"req:"+ JSON.toJSONString(req));
        Account account = accountService.getByMobilePhone(req.getMobilePhone());  //获取账号信息
        if (account == null) {
            intactUtil.sendIntact(batchNo,"login",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"未注册，请验证码登录");
            return PicaResponse.toResponse(null, PicaResultCode.RESULE_DATA_NONE.code(), "未注册，请验证码登录");
        }

        if (StringUtils.isBlank(req.getPassword())) {
            //验证码登录
            req.setFlag("0");
            intactUtil.sendIntact(batchNo,"login",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"校验验证码前的返回，因为验证码可能校验不通过，就直接返回了");
            //校验验证码
            this.checkAuthCode(req);
        } else {  //密码登录
            if (!StringUtils.equals(req.getPassword(), account.getPassword())) {
                intactUtil.sendIntact(batchNo,"login",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"请输入正确的密码");
                return PicaResponse.toResponse(null, PicaResultCode.PARAM_IS_INVALID.code(), "请输入正确的密码");
            }
        }

        //更新最后登录时间
        Account update = new Account();
        update.setId(account.getId());
        update.setLastLoginTime(new Date());
        if (StringUtils.isBlank(account.getUnionid()) && StringUtils.isNotBlank(req.getUnionid())) {
            update.setUnionid(req.getUnionid());  //绑定微信unionid
            update.setModifyId(account.getId());
            update.setModifyTime(new Date());
        }
        accountService.updateAccountById(update);

        //登录成功，清除旧token，生成新token
        String deviceType = super.getDeviceInfo("device_type");  //1:pc 2:android 3:ios
        String newToken = this.generateToken(account, deviceType);
        intactUtil.sendIntact(batchNo,"login",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"req:"+ JSON.toJSONString(req));
        return PicaResponse.toResponse(newToken);
    }

    //    @ApiOperation("注册")
//    @PostMapping("/register")
    public PicaResponse<LoginResult> register(@RequestBody AccountReq req) {
        this.checkMobilePhone(req.getMobilePhone());
        accountUtils.checkRegisterMobilePhoneAndAuthCode(req.getMobilePhone(),req.getFlag(),req.getAuthCode());
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo,"register",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1,"req:"+ JSON.toJSONString(req));
        String deviceType = super.getDeviceInfo("device_type");  //1:pc 2:android 3:ios
        Account account = new Account();
        account.setMobilePhone(EncryptUtils.encryptContent(req.getMobilePhone(), EncryptConstants.ENCRYPT_TYPE_MOBILE));
        switch (deviceType) {  //注册来源
            case "1":
                account.setRegisterSource(CommonConstants.SYSTEM_TYPE_P024_NO_3);  //pc
                break;
            case "2":
                account.setRegisterSource(CommonConstants.SYSTEM_TYPE_P024_NO_1);  //android
                break;
            case "3":
                account.setRegisterSource(CommonConstants.SYSTEM_TYPE_P024_NO_2);  //ios
                break;
            default:
                account.setRegisterSource(AccountTypeEnum.DEVICE_TYPE_H5.getCode());  //H5注册
        }
        //创建账号
        accountService.createAccount(account);

        //生成token并返回
        String newToken = this.generateToken(account, deviceType);

        LoginResult result = new LoginResult();
        result.setToken(newToken);
        intactUtil.sendIntact(batchNo,"register",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"req:"+ JSON.toJSONString(req));
        return PicaResponse.toResponse(result);
    }

    @ApiOperation("H5端验证码登录,无需完善信息")
    @PostMapping("/login-register/v1")
//    @RepeatForbidden(uniqueKey = "content")
    //当前版本存在性能问题 luo优化后上
    public PicaResponse loginRegister(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        this.checkMobilePhone(request.getMobile());
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo,"h5-loginRegister",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1,"entity:"+ JSON.toJSONString(entity));
        AccountReq req = new AccountReq();
        req.setMobilePhone(request.getMobile());
        //  登录或注册，只能使用验证码
        req.setPassword(null);
        req.setAuthCode(request.getAuthCode());
        req.setFlag("0");
        req.setUnionid(request.getUnionId());

        //  判断账号是否已经存在
        Account account = accountService.getByMobilePhone(req.getMobilePhone());
        if (account != null) {
            //  登录
            PicaResponse response = null;
            try {
                response = this.login(req);
            } catch (PicaException e) {
                if(e.getCode().equals(PicaResultCode.PARAM_IS_INVALID.code()) || e.getCode().equals(PicaResultCode.RESULE_DATA_NONE.code())){
                    intactUtil.sendIntact(batchNo,"h5-loginRegister",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"验证码错误或过期-不加入提醒，返回值:"+ JSON.toJSONString(response));
                }
                throw e;
            }
            if (response.getData() != null) {
                LoginResult result = new LoginResult();
                result.setToken(response.getData().toString());
                intactUtil.sendIntact(batchNo,"h5-loginRegister",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"登录成功，返回值:"+ JSON.toJSONString(response.getData()));

                return PicaResponse.toResponse(result);
            }
            return response;
        } else {
            //  注册
            PicaResponse<LoginResult> result = null;
            try {
                result = this.register(req);
            } catch (PicaException e) {
                if(e.getCode().equals(PicaResultCode.PARAM_IS_INVALID.code()) || e.getCode().equals(PicaResultCode.RESULE_DATA_NONE.code())){
                    intactUtil.sendIntact(batchNo,"h5-loginRegister",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"验证码错误或过期-不加入提醒，返回值:"+ JSON.toJSONString(result));
                }
                throw e;
            }
            intactUtil.sendIntact(batchNo,"h5-loginRegister",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"注册成功，返回值:"+ JSON.toJSONString(result));
            return result;
        }
    }

    @ApiOperation("webLive端验证码登录-沿用 /login-register/v1")
    @PostMapping("/login-register/v2")
//    @RepeatForbidden(uniqueKey = "content")
    //当前版本存在性能问题 luo优化后上
    public PicaResponse loginRegisterV2(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        this.checkMobilePhone(request.getMobile());
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo,"webLive-loginRegister",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1,"entity:"+ JSON.toJSONString(entity));
        AccountReq req = new AccountReq();
        req.setMobilePhone(request.getMobile());
        //  登录或注册，只能使用验证码
        req.setPassword(null);
        req.setAuthCode(request.getAuthCode());
        req.setFlag("0");
        req.setUnionid(request.getUnionId());

        //  判断账号是否已经存在
        Account account = accountService.getByMobilePhone(req.getMobilePhone());
        if (account != null) {
            //  登录
            PicaResponse response = null;
            try {
//                response = this.login(req);

                this.checkMobilePhone(req.getMobilePhone());
                logger.info("login:{}", JSONObject.toJSONString(req));
                //接入新旭事务一致性
                String batchNo1 = IntactUtils.getUUID();
                intactUtil.sendIntact(batchNo1,"login",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1,"req:"+ JSON.toJSONString(req));
                Account account1 = accountService.getByMobilePhone(req.getMobilePhone());  //获取账号信息
                if (account1 == null) {
                    intactUtil.sendIntact(batchNo1,"login",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"未注册，请验证码登录");
                    return PicaResponse.toResponse(null, PicaResultCode.RESULE_DATA_NONE.code(), "未注册，请验证码登录");
                }

                if (StringUtils.isBlank(req.getPassword())) {
                    //验证码登录
                    req.setFlag("0");
                    intactUtil.sendIntact(batchNo1,"login",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"校验验证码前的返回，因为验证码可能校验不通过，就直接返回了");
                    //校验验证码
                    this.checkAuthCode(req);
                } else {  //密码登录
                    if (!StringUtils.equals(req.getPassword(), account1.getPassword())) {
                        intactUtil.sendIntact(batchNo1,"login",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"请输入正确的密码");
                        return PicaResponse.toResponse(null, PicaResultCode.PARAM_IS_INVALID.code(), "请输入正确的密码");
                    }
                }

                //更新最后登录时间
                Account update = new Account();
                update.setId(account1.getId());
                update.setLastLoginTime(new Date());
                if (StringUtils.isBlank(account1.getUnionid()) && StringUtils.isNotBlank(req.getUnionid())) {
                    update.setUnionid(req.getUnionid());  //绑定微信unionid
                    update.setModifyId(account1.getId());
                    update.setModifyTime(new Date());
                }
                accountService.updateAccountById(update);

                //登录成功，清除旧token，生成新token
                String deviceType = super.getDeviceInfo("device_type");  //1:pc 2:android 3:ios
                String newToken = this.generateTokenWebLive(account1, deviceType);
                intactUtil.sendIntact(batchNo1,"login",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"req:"+ JSON.toJSONString(req));
                response = PicaResponse.toResponse(newToken);


            } catch (PicaException e) {
                if(e.getCode().equals(PicaResultCode.PARAM_IS_INVALID.code()) || e.getCode().equals(PicaResultCode.RESULE_DATA_NONE.code())){
                    intactUtil.sendIntact(batchNo,"webLive-loginRegister",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"验证码错误或过期-不加入提醒，返回值:"+ JSON.toJSONString(response));
                }
                throw e;
            }
            if (response.getData() != null) {
                LoginResult result = new LoginResult();
                result.setToken(response.getData().toString());
                intactUtil.sendIntact(batchNo,"webLive-loginRegister",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"登录成功，返回值:"+ JSON.toJSONString(response.getData()));

                return PicaResponse.toResponse(result);
            }
            return response;
        } else {
            //  注册
            PicaResponse<LoginResult> result = null;
            try {
//                result = this.register(req);

                this.checkMobilePhone(req.getMobilePhone());
                accountUtils.checkRegisterMobilePhoneAndAuthCode(req.getMobilePhone(),req.getFlag(),req.getAuthCode());
                //接入新旭事务一致性
                String batchNo2 = IntactUtils.getUUID();
                intactUtil.sendIntact(batchNo2,"register",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1,"req:"+ JSON.toJSONString(req));
                String deviceType = super.getDeviceInfo("device_type");  //1:pc 2:android 3:ios
                Account account2 = new Account();
                account2.setMobilePhone(EncryptUtils.encryptContent(req.getMobilePhone(), EncryptConstants.ENCRYPT_TYPE_MOBILE));
                switch (deviceType) {  //注册来源
                    case "1":
                        account2.setRegisterSource(CommonConstants.SYSTEM_TYPE_P024_NO_3);  //pc
                        break;
                    case "2":
                        account2.setRegisterSource(CommonConstants.SYSTEM_TYPE_P024_NO_1);  //android
                        break;
                    case "3":
                        account2.setRegisterSource(CommonConstants.SYSTEM_TYPE_P024_NO_2);  //ios
                        break;
                    default:
                        account2.setRegisterSource(AccountTypeEnum.DEVICE_TYPE_H5.getCode());  //H5注册
                }
                //创建账号
                accountService.createAccount(account2);

                //生成token并返回
                String newToken = this.generateTokenWebLive(account2, deviceType);

                LoginResult result1 = new LoginResult();
                result1.setToken(newToken);
                intactUtil.sendIntact(batchNo2,"register",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"req:"+ JSON.toJSONString(req));
//                return PicaResponse.toResponse(result);

                result = PicaResponse.toResponse(result1);

            } catch (PicaException e) {
                if(e.getCode().equals(PicaResultCode.PARAM_IS_INVALID.code()) || e.getCode().equals(PicaResultCode.RESULE_DATA_NONE.code())){
                    intactUtil.sendIntact(batchNo,"webLive--loginRegister",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"验证码错误或过期-不加入提醒，返回值:"+ JSON.toJSONString(result));
                }
                throw e;
            }
            intactUtil.sendIntact(batchNo,"webLive--loginRegister",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"注册成功，返回值:"+ JSON.toJSONString(result));
            return result;
        }
    }

    //手机格式校验
    private void checkMobilePhone(String mobilePhone) {
        if (StringUtils.isBlank(mobilePhone) || !ValidateUtils.isMobile(mobilePhone)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "请输入正确的手机号");
        }
    }

    //获取验证码redis key
    private String getAuthCodeKey(String mobilePhone, String flag) {
        logger.info(Constants.AUTH_CODE_PREFIX + flag + "-" + EncryptUtils.encryptContent(mobilePhone, EncryptConstants.ENCRYPT_TYPE_MOBILE));
        return Constants.AUTH_CODE_PREFIX + flag + "-" + EncryptUtils.encryptContent(mobilePhone, EncryptConstants.ENCRYPT_TYPE_MOBILE);
    }

    //校验验证码
    private void checkAuthCode(AccountReq req) {
        String flag = StringUtils.isBlank(req.getFlag()) ? "0" : req.getFlag();

        if (StringUtils.isBlank(req.getAuthCode())) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }

        String authCodeKey = this.getAuthCodeKey(req.getMobilePhone(), flag);
        logger.info(authCodeKey);
        String cacheCode = redisClient.get(authCodeKey);  //从redis获取验证码

        if (StringUtils.isBlank(cacheCode)) {
            throw new PicaException(PicaResultCode.RESULE_DATA_NONE.code(), "短信验证码已过期，请重新获取");
        }
        if (!StringUtils.equals(req.getAuthCode(), cacheCode)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }
        redisClient.del(authCodeKey);  //清除验证码
    }

    //生成H5 token
    private String generateH5Token(Account account) {
        String newToken = StringUtils.EMPTY;
        try {
            //先清除旧token
            String tokenValue = "token-doctor-" + account.getId().toString();
            String oldToken = redisClient.get(tokenValue + "-h5");
            if (StringUtils.isNotBlank(oldToken)) {
                redisClient.del(oldToken);
            }
            //生成新token
            int expiredSeconds = 30 * 24 * 60 * 60;  //H5 token有效期30天
            newToken = UUID.randomUUID().toString().replace("-", "").toUpperCase();
            String tokenKey = "token-" + newToken;
            redisClient.set(tokenKey, tokenValue, expiredSeconds);
            redisClient.set(tokenValue + "-h5", tokenKey, expiredSeconds);
            //用户数据放入缓存
            PicaUser picaUser = new PicaUser();
            picaUser.setToken(newToken);
            picaUser.setId(account.getId().intValue());
            picaUser.setMobile(account.getMobilePhone());
            picaUser.setName(EncryptUtils.decryptContent(account.getMobilePhone(), EncryptConstants.ENCRYPT_TYPE_MOBILE, EncryptConstants.ENCRYPT_DECRYPT_KEY).replaceAll("(\\d{3})\\d{4}(\\w{4})", "$1****$2"));
            picaUser.setCreated_time(account.getCreatTime());
            Map<String, String> data = Object2Map.objectToMapString("yyyy-MM-dd HH:mm:ss", picaUser, new String[0]);
            data.put("sysCode", "h5");
            data.forEach((key, value) -> {
                value = value == null ? "" : value;
                redisClient.hset(tokenValue, key, value);
            });
        } catch (Exception ex) {
            logger.error("生成H5 token异常：{}" + ex.getMessage(), ex);
        }
        return newToken;
    }

    private String generateH5TokenWebLive(Account account) {
        String newToken = StringUtils.EMPTY;
        try {
            //先清除旧token
            String tokenValue = "token-doctor-" + account.getId().toString();
            String oldToken = redisClient.get(tokenValue + "-h5");
            if (StringUtils.isNotBlank(oldToken)) {
                redisClient.del(oldToken);
            }
            //生成新token
            int expiredSeconds = 30 * 24 * 60 * 60;  //H5 token有效期30天
            newToken = UUID.randomUUID().toString().replace("-", "").toUpperCase();
            String tokenKey = "token-" + newToken;
            redisClient.set(tokenKey, tokenValue, expiredSeconds);
            redisClient.set(tokenValue + "-h5", tokenKey, expiredSeconds);
            //用户数据放入缓存
            PicaUser picaUser = new PicaUser();
            picaUser.setToken(newToken);
            picaUser.setId(account.getId().intValue());
            picaUser.setMobile(account.getMobilePhone());
            picaUser.setName(account.getName()); //保留原name
            picaUser.setCreated_time(account.getCreatTime());
            Map<String, String> data = Object2Map.objectToMapString("yyyy-MM-dd HH:mm:ss", picaUser, new String[0]);
            data.put("sysCode", "h5");
            data.forEach((key, value) -> {
                value = value == null ? "" : value;
                redisClient.hset(tokenValue, key, value);
            });
        } catch (Exception ex) {
            logger.error("生成H5 token异常：{}" + ex.getMessage(), ex);
        }
        return newToken;
    }

    //清除旧token，生成新token
    private String generateToken(Account account, String deviceType) {
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo,"generateToken",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1,"account:"+ JSON.toJSONString(account)+",deviceType:"+deviceType);
        String newToken;
        switch (deviceType) {  //设备信息
            case "1":  //pc
                //TODO
                newToken = StringUtils.EMPTY;
                break;
            case "2":  //android
            case "3":  //ios
                //TODO  更新设备信息
                newToken = StringUtils.EMPTY;
                break;
            default:  //H5
                newToken = this.generateH5Token(account);
        }
        intactUtil.sendIntact(batchNo,"generateToken",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"newToken:"+newToken);
        return newToken;
    }

    private String generateTokenWebLive(Account account, String deviceType) {
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo,"generateToken",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1,"account:"+ JSON.toJSONString(account)+",deviceType:"+deviceType);
        String newToken;
        switch (deviceType) {  //设备信息
            case "1":  //pc
                //TODO
                newToken = StringUtils.EMPTY;
                break;
            case "2":  //android
            case "3":  //ios
                //TODO  更新设备信息
                newToken = StringUtils.EMPTY;
                break;
            default:  //H5
                newToken = this.generateH5TokenWebLive(account);
        }
        intactUtil.sendIntact(batchNo,"generateToken",com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,"newToken:"+newToken);
        return newToken;
    }

    public static void main(String[] args) {
        JSON.toJSONString(null);
        System.out.println("成功");
    }

    /**
     * 旧的注册接口，下个版本可以去掉
     * @param req
     * @return
     */
//    @ApiOperation("H5端一键登录功能,无需完善信息 旧接口")
//    @PostMapping("/login-register")
//    public PicaResponse<String> loginRegister(@RequestBody AccountReq req) {
//        this.checkMobilePhone(req.getMobilePhone());
//        req.setPassword(null);  //登录或注册，只能使用验证码
//
//        //判断账号是否已经存在
//        Account account = accountService.getByMobilePhone(req.getMobilePhone());
//        if (account != null) {
//            return this.login(req);  //登录
//        } else {
//            return this.registerOld(req);  //注册
//        }
//    }

//    public PicaResponse<String> registerOld(@RequestBody AccountReq req) {
//        this.checkMobilePhone(req.getMobilePhone());
//        this.checkAuthCode(req);
//        String deviceType = super.getDeviceInfo("device_type");  //1:pc 2:android 3:ios
//        Account account = new Account();
//        account.setMobilePhone(EncryptUtils.encryptContent(req.getMobilePhone(), EncryptConstants.ENCRYPT_TYPE_MOBILE));
//        switch (deviceType) {  //注册来源
//            case "1":
//                account.setRegisterSource(CommonConstants.SYSTEM_TYPE_P024_NO_3);  //pc
//                break;
//            case "2":
//                account.setRegisterSource(CommonConstants.SYSTEM_TYPE_P024_NO_1);  //android
//                break;
//            case "3":
//                account.setRegisterSource(CommonConstants.SYSTEM_TYPE_P024_NO_2);  //ios
//                break;
//            default:
//                account.setRegisterSource(4);  //H5注册
//        }
//        //创建账号
//        accountService.createAccount(account);
//        //生成token并返回
//        String newToken = this.generateToken(account, deviceType);
//        return PicaResponse.toResponse(newToken);
//    }
}
