// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.PermissionDoctorRole;
import com.pica.cloud.account.account.server.entity.PermissionRole;
import com.pica.cloud.account.account.server.mapper.PermissionDoctorRoleMapper;
import com.pica.cloud.account.account.server.mapper.PermissionRoleMapper;
import com.pica.cloud.account.account.server.req.HospitalRoleDetailReq;
import com.pica.cloud.account.account.server.req.HospitalRoleListReq;
import com.pica.cloud.account.account.server.resp.HospitalRoleResp;
import com.pica.cloud.account.account.server.resp.HospitalSaasRoleResp;
import com.pica.cloud.account.account.server.resp.RoleDto;
import com.pica.cloud.account.account.server.service.HospitalSaasRoleService;
import com.pica.cloud.account.account.server.util.captcha.CommonUtils;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @Author qinwh
 * @Date 2022/3/1 19:33
 */
@Service
public class HospitalSaasRoleServiceImpl implements HospitalSaasRoleService {
    @Autowired
    PermissionRoleMapper permissionRoleMapper;
    @Autowired
    PermissionDoctorRoleMapper permissionDoctorRoleMapper;

    @Override
    public int insertAndModify(HospitalRoleDetailReq req, PicaUser user) {
        int num;
        if(null != req.getId()){
            PermissionRole role = permissionRoleMapper.selectByPrimaryKey(req.getId());
            role.setRoleName(req.getName());
            role.setRemark(req.getDescribe());
            role.setModifiedId(Long.valueOf(user.getId()));
            role.setModifiedTime(new Date());
            num = permissionRoleMapper.updateByPrimaryKeySelective(role);
        }else {
            PermissionRole role = new PermissionRole();
            role.setRoleCode("saas_doctor_admin");
            role.setRoleName(req.getName());
            role.setRemark(req.getDescribe());
            CommonUtils.setCommonParam(role, user.getId(), Calendar.getInstance().getTime());
            num = permissionRoleMapper.insert(role);
        }
//        PermissionRole role = permissionRoleMapper.selectByPrimaryKey(req.getId());
//        //新增
//        if (Objects.isNull(role)) {
//            //新增
//            role = new PermissionRole();
//            BeanUtils.copyProperties(req, role);
//            CommonUtils.setCommonParam(role, user.getId(), Calendar.getInstance().getTime());
//            permissionRoleMapper.insert(role);
//        } else {
//            //更新
//            // todo   roleCode 字段格式定义
//            role.setRoleName(req.getName());
//            // todo  描述信息 需新增字段
//            permissionRoleMapper.updateByPrimaryKeySelective(role);
//        }
        return num;
    }

    @Override
    public HospitalRoleResp ListByPage(HospitalRoleListReq req) {
        ArrayList<Object> list = new ArrayList<>(3);
        list.add(1);
        list.add(2);
        //todo  过滤当前人员的角色信息
        //list.add();
        Map<String, Object> map = new HashMap(2);
        map.put("list", list);
        map.put("name", req.getName());
        int count = permissionRoleMapper.ListCountByPage(map);
        if (count < 1) {
            return new HospitalRoleResp(Collections.emptyList(), 0);
        }
        map.put("pageNo", (req.getPageNo() - 1) * req.getPageSize());
        map.put("pageSize", req.getPageSize());
        return new HospitalRoleResp(permissionRoleMapper.ListByPage(map), count);
    }

    @Override
    @Transactional
    public int delete(Long id) {
        permissionRoleMapper.deleteById(id);
        //把这个角色下的人员信息 调整为默认角色
        permissionDoctorRoleMapper.upsertDefaultRole(id);
        return 1;
    }

    @Override
    public HospitalSaasRoleResp querySaasRoles() {
        List<RoleDto> roleDtos = permissionRoleMapper.querySaasRoles();
        return new HospitalSaasRoleResp(roleDtos);
    }
}
