package com.pica.cloud.account.account.server.util;

import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import java.io.IOException;

/**
 * @author Laurence Cao
 *
 */
@Component
public class MemcachedClientWrapper {

    private final int EXPIRE = 5 * 60; // 5 minutes
    private MemcachedClient cli;

    public MemcachedClientWrapper(@Value("${memcached.url}") String url) {
        try {
            cli = new MemcachedClient(new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).build(), AddrUtil.getAddresses(url));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String get(String token) {
        return (String)cli.get(token);
    }

    public void set(String token, String answer) {
        cli.set(token, EXPIRE, answer);
    }

    public void remove(String token) {
        cli.delete(token);
    }

}
