package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.service.AccountService;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author andong
 * @create 2019/6/6
 */
@Api(description = "用户状态")
@RestController
@RequestMapping("/status")
public class AccountStatusController extends AccountBaseController {

    @Autowired
    private AccountService accountService;

    @ApiOperation("获取用户状态信息")
    @GetMapping("")
    public PicaResponse<Account> getStatus() {
        long doctorId = super.getDoctorIdByToken();
        Account account = accountService.getById(doctorId);
        return PicaResponse.toResponse(account);
    }

    @ApiOperation("获取用户缓存")
    @GetMapping("/cache")
    public PicaResponse<Map<String, String>> getCache(@RequestParam("id") long id) {
        return PicaResponse.toResponse(accountService.getCache(id));
    }

    @ApiOperation("刷新用户缓存")
    @GetMapping("/cache/refresh")
    public PicaResponse refreshCache(@RequestParam("id") long id, @RequestParam(value = "token", required = false) Long token) {
        if (id < 0 && (token == null || token.longValue() != 1564736008307L)) {
            return PicaResponse.toResponse();
        }
        new Thread(() -> accountService.refreshCache(id)).start();
        return PicaResponse.toResponse();
    }

}
