package com.pica.cloud.account.account.server.util.captcha;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import org.springframework.stereotype.Component;
import java.awt.*;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

/**
 * @author Laurence Cao
 *
 */
@Component
public class CaptchaGenerator {

    protected RangeMap<Integer, CaptchaContext> ctxs = TreeRangeMap.create();
    protected List<Generator> gens = new ArrayList();

    class NumberLetterGenerator implements Generator {
        @Override
        public String generateChars(int size) {
            return CaptchaUtil.generateUUIDText(size);
        }
    }

    public CaptchaGenerator() throws FontFormatException, IOException {
        int h = 40;
        ctxs.put(Range.closedOpen(0, h), new CaptchaContext(h * 4, h, h / 5 * 4, true));
        h *= 2;
        ctxs.put(Range.closedOpen(h / 2, h), new CaptchaContext(h * 4, h, h / 5 * 4, true));
        h *= 2;
        ctxs.put(Range.closedOpen(h / 2, Integer.MAX_VALUE), new CaptchaContext(h * 4, h, h / 5 * 4, true));
        gens.add(new NumberLetterGenerator());
    }

    @SuppressWarnings("unused")
    public byte[] createCaptcha(String text, int width, int height) {
        CaptchaContext ctx = ctxs.get(height);
        if (ctx == null) {
            ctx = ctxs.get(0);
        }
        return CaptchaUtil.generateImage(text, ctx);
    }

    public String generateChars(int size) {
        int idx = ThreadLocalRandom.current().nextInt(gens.size());
        Generator gen = gens.get(idx);
        return gen.generateChars(size);
    }

}
