package com.pica.cloud.account.account.server.util.captcha;

import java.awt.*;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

/**
 * @author Laurence Cao
 *
 */
public class CaptchaContext {

    final Random rnd = ThreadLocalRandom.current();
    final int fontCount = 4;

    public int width;
    public int height;
    public float fontSize;
    public boolean showGrid;

    public int gridSize = 1 + rnd.nextInt(10);
    public int rotationAmplitude = rnd.nextInt(10);
    public int scaleAmplitude = 2 * rotationAmplitude;

    public Font font;

    public CaptchaContext(int width, int height, int fontSize, boolean showGrid) throws FontFormatException, IOException {
        this.width = width;
        this.height = height;
        this.fontSize = fontSize;
        this.showGrid = showGrid;
        String name = "/" + (ThreadLocalRandom.current().nextInt(0, fontCount) + 1) + ".ttf";
        this.font = Font.createFont(Font.TRUETYPE_FONT, CaptchaGenerator.class.getResourceAsStream(name));
    }

    public int rndGridSize() {
        return 1 + rnd.nextInt(10);
    }

    public int rndRotationAmplitude() {
        return rnd.nextInt(10);
    }

    public int rndScaleAmplitude() {
        return rnd.nextInt(20);
    }

    public float rndFontSize() {
        return fontSize + rnd.nextFloat();
    }

}
