package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.LogPWDModifyEntity;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.PasswordService;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class PasswordServiceImpl implements PasswordService {

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Override
    public void modifyPassword(Integer acctId, String oldPwd, String pwd) {
        AccountInfoEntity entity = accountInfoDetailMapper.selectByPrimaryKey(acctId);
        if (entity.getPassword().equals(oldPwd)) {
            AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
            accountInfoEntity.setId(acctId);
            accountInfoEntity.setModifiedId(acctId);
            accountInfoEntity.setModifiedTime(new Date());
            accountInfoEntity.setPassword(pwd);
            accountInfoDetailMapper.updatePasswordByPrimaryKey(accountInfoEntity);
            //密码修改日志
            LogPWDModifyEntity logPWDModifyEntity = AccountLogEntityUtils.getLogPWDModifyEntity(acctId, entity.getMobilePhone(),
                    oldPwd, pwd, AccountTypeEnum.LOG_TYPE_PASSWORD.getCode());
            picaLogUtils.info(logPWDModifyEntity);
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_PASSWORD_ERROR);
        }
    }

    @Override
    public void forgetPassword(BaseRequest request) {
        AccountInfoEntity entity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(request.getMobile()));
        if (entity != null) {
            Integer accId = entity.getId();
            AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
            accountInfoEntity.setId(accId);
            accountInfoEntity.setModifiedId(accId);
            accountInfoEntity.setModifiedTime(new Date());
            accountInfoEntity.setPassword(request.getPassword());
            accountInfoDetailMapper.updatePasswordByPrimaryKey(accountInfoEntity);
            //密码修改日志
            LogPWDModifyEntity logPWDModifyEntity = AccountLogEntityUtils.getLogPWDModifyEntity(accId, entity.getMobilePhone(),
                    "", request.getPassword(), AccountTypeEnum.LOG_TYPE_PASSWORD.getCode());
            picaLogUtils.info(logPWDModifyEntity);
        } else {
            //未注册，请先注册
            throw new AccountException(AccountExceptionEnum.PICA_NOT_REGISTER);
        }
    }
}
