package com.pica.cloud.account.account.server.util;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.controller.AccountController;
import com.pica.cloud.account.account.server.entity.AccountPatientInfoEntity;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.mapper.AccountPatientInfoMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.utils.ValidateUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * 账户工具类
 */
@Component
public class AccountUtils {

    @Autowired

    private ICacheClient cacheClient;

    private Logger logger = LoggerFactory.getLogger(AccountController.class);

    @Autowired
    private AccountPatientInfoMapper accountPatientInfoMapper;

    @Autowired
    private DoctorMapper doctorInfoMapper;

    private static final String AUTH_CODE_PREFIX = "authCode-";
    private static final String AUTH_CODE_COUNT_PREFIX = "authCode-count-";

    //手机格式校验
    public static void checkMobilePhone(String mobilePhone) {
        if (StringUtils.isBlank(mobilePhone) || !ValidateUtils.isMobile(mobilePhone)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "请输入正确的手机号");
        }
    }

    //手机格式校验
    public static void checkPassword(String password) {
        if (StringUtils.isBlank(password)) {
            throw new PicaException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), AccountExceptionEnum.PICA_NOT_EMPTY.getMessage());
        }
    }

    //获取验证码redis key
    public static String getAuthCodeKey(String mobilePhone, String flag) {
        return AUTH_CODE_PREFIX + flag + "-" + AESUtil.encryptV0(mobilePhone);
    }

    //校验验证码
    public void checkAuthCode(String mobile, String type, String sysCode) {
        String flag = org.apache.commons.lang.StringUtils.isBlank(type) ? "0" : type;
        if (org.apache.commons.lang.StringUtils.isBlank(sysCode)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }
        String authCodeKey = AccountUtils.getAuthCodeKey(mobile, flag);
        String cacheCode = cacheClient.get(authCodeKey);  //从redis获取验证码
        if (org.apache.commons.lang.StringUtils.isBlank(cacheCode)) {
            throw new PicaException(PicaResultCode.RESULE_DATA_NONE.code(), "短信验证码已过期，请重新获取");
        }
        if (!org.apache.commons.lang.StringUtils.equals(sysCode, cacheCode)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }
        //清除验证码
        cacheClient.del(authCodeKey);
    }

    //手机号和验证码校验
    public void checkMobilePhoneAndAuthCode(String mobile, String type, String sysCode) {
        if (StringUtils.isBlank(mobile) || !ValidateUtils.isMobile(mobile)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "请输入正确的手机号");
        }
        String flag = org.apache.commons.lang.StringUtils.isBlank(type) ? "0" : type;
        if (org.apache.commons.lang.StringUtils.isBlank(sysCode)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }
        String authCodeKey = AccountUtils.getAuthCodeKey(mobile, flag);
        //验证码3次校验测试不通过，直接删除
        String authCodeCount = AUTH_CODE_COUNT_PREFIX + flag + "-" + AESUtil.encryptV0(mobile);

        logger.info("验证码缓存信息----->：" + this.getAuthCodeKey(mobile, flag));

        if (cacheClient.exists(authCodeCount) && Integer.parseInt(cacheClient.get(authCodeCount)) > 2) {
            cacheClient.del(authCodeKey);
        }

        String cacheCode = cacheClient.get(authCodeKey);  //从redis获取验证码
        if (org.apache.commons.lang.StringUtils.isBlank(cacheCode)) {
            //第四次删除计数器
            cacheClient.del(authCodeCount);
            throw new PicaException(PicaResultCode.RESULE_DATA_NONE.code(), "短信验证码已失效，请重新获取");
        }
        if (!org.apache.commons.lang.StringUtils.equals(sysCode, cacheCode)) {
            cacheClient.incr(authCodeCount);
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }
        cacheClient.del(authCodeKey);
    }


    public void checkRegisterMobilePhoneAndAuthCode(String mobile, String type, String sysCode) {
        if (StringUtils.isBlank(mobile) || !ValidateUtils.isMobile(mobile)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "请输入正确的手机号");
        }
        String flag = org.apache.commons.lang.StringUtils.isBlank(type) ? "0" : type;
        if (org.apache.commons.lang.StringUtils.isBlank(sysCode)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }
        String authCodeKey = RegisterCodeKeyUtils.getRegisterKey(mobile, flag, sysCode);
        //从redis中删除短信验证码，如果能够删除成功，说明验证码正确
        Long num = cacheClient.del(authCodeKey);
        logger.info("key"+authCodeKey);
        logger.info("success"+num);
        if (num != 1) {
            throw new PicaException(PicaResultCode.RESULE_DATA_NONE.code(), "短信验证码错误");
        }
    }

    /**
     * 请求参数解密、反序列化
     *
     * @param params
     * @param zClass
     * @param <T>
     * @return
     */
    public static <T> T getRequestEntity(String params, Class<T> zClass) throws Exception {
        String json = AESUtil.decryptV0(params);
        return JSONObject.parseObject(json, zClass);
    }

    /**
     * 获取终端来源
     *
     * @param registerSource
     * @return
     */
    public static String getSourceType(Integer registerSource) {
        String sourceType = StringUtils.EMPTY;
        switch (registerSource) {
            case 3:
                sourceType = "web";
                break;
            case 4:
                sourceType = "h5";
                break;
            case 5:
                sourceType = "admin";
                break;
            default:
                sourceType = "app";
        }
        return sourceType;
    }

    /**
     * 通过产品线类型获取用户id
     *
     * @param productType
     * @param AcctId
     * @return
     */
    public Long getUserIdByAcctId(Integer productType, Integer AcctId) {
        Long userId = null;
        if (productType == AccountTypeEnum.PRODUCT_TYPE_DOCTOR.getCode()) {
            userId = doctorInfoMapper.selectUserIdByAcctId(AcctId);
        } else if (productType == AccountTypeEnum.PRODUCT_TYPE_HEALTH.getCode()) {
            AccountPatientInfoEntity accountPatientInfoEntity = accountPatientInfoMapper.selectByAcctId(AcctId);
            userId = accountPatientInfoEntity.getId().longValue();
        }
        return userId;
    }


    /**
     * 校验手机号是否注册过
     *
     * @param mobile
     */
//    public boolean checkRegisterMobile(String mobile) {
//        String encrypt = AESUtil.encryptV0(mobile);
//        AccountContact accountContact = accountContactServer.selectByMobile(encrypt);
//        return (accountContact != null && accountContact.getAcctId() != null);
//    }
}
