package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.mapper.AccountMapper;
import com.pica.cloud.account.account.server.service.AccountService;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;

/**
 * @author andong
 * @create 2019/5/20
 */
@Service
public class AccountServiceImpl implements AccountService {

    @Autowired
    private AccountMapper accountMapper;

    //根据手机号获取账号
    @Override
    public Account getByMobilePhone(String mobilePhone) {
        String encryptMobilePhone = EncryptCreateUtil.encrypt(mobilePhone);
        return accountMapper.getByMobilePhone(encryptMobilePhone);
    }

    //根据微信unionid获取账号
    public Account getByUnionid(String unionid) {
        return accountMapper.getByUnionid(unionid);
    }

    //创建账号
    @Override
    @Transactional
    public void createAccount(Account account) {
        Date currentTime = new Date();
        account.setMobilePhone(EncryptCreateUtil.encrypt(account.getMobilePhone()));  //手机号加密
        account.setDeleteFlag(1);
        account.setCreatId(0L);
        account.setModifyId(0L);
        account.setCreatTime(currentTime);
        account.setModifyTime(currentTime);
        account.setFirstLoginTime(currentTime);
        account.setLastLoginTime(currentTime);
        accountMapper.insertSelective(account);
    }

    //更新账号信息
    @Override
    @Transactional
    public void updateAccountById(Account account) {
        accountMapper.updateByIdSelective(account);
    }
}
