package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.common.req.circle.CircleAcctInitReq;
import com.pica.cloud.account.account.common.req.shop.ShopAcctInitReq;
import com.pica.cloud.account.account.server.service.CircleAccountService;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.service.starter.interceptor.EnabledLoginValidate;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(description = "")
@RestController
@RequestMapping("/shop")
public class ShopUserController {

    private Logger logger = LoggerFactory.getLogger(ShopUserController.class);

    @Autowired
    private CircleAccountService circleAccountService;

    @PostMapping("/acct")
    @EnabledLoginValidate
    public PicaResponse<List<Integer>> shopUserInit(@RequestBody ShopAcctInitReq shopAcctInitReq) {
        return PicaResponse.toResponse(circleAccountService.createShopAccount(shopAcctInitReq));
    }

}
