package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.DoctorService;
import com.pica.cloud.account.account.server.service.PasswordService;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(description = "密码资源")
@RestController
@RequestMapping("/password")
public class PasswordController extends AccountBaseController {

    @Autowired
    private PasswordService passwordService;
    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;
    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    private DoctorService doctorService;

    /**
     * 修改密码
     *
     * @return
     */
    @ApiOperation("修改密码接口")
    @PostMapping(value = "/modify")
    public PicaResponse modifyPassword(@RequestBody EncryptEntity entity) throws Exception {
        Long doctorId= super.getDoctorIdByToken();
        Doctor doctorInfo = doctorService.getDoctorInfo(doctorId.intValue());
        String mobile = doctorInfo.getMobilePhone();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(mobile);
        if (accountInfoEntity != null) {
            BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
            String oldPwd = request.getOldPwd();
            String password = request.getPassword();
            if (!StringUtils.isEmpty(password) && !StringUtils.isEmpty(oldPwd)) {
                if (!password.equals(oldPwd)) {
                    passwordService.modifyPassword(mobile, oldPwd, password);
                    return PicaResponse.toResponse();
                } else {
                    throw new AccountException(AccountExceptionEnum.PICA_PASSWORD_EQUAL);
                }
            } else {
                throw new AccountException(AccountExceptionEnum.PICA_PASSWORD_NULL);
            }
        }
        return null;
    }

    /**
     * 忘记密码
     *
     * @return
     */
    @ApiOperation("忘记密码接口")
    @PostMapping(value = "/reset")
    public PicaResponse forgetPassword(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        accountUtils.checkMobilePhoneAndAuthCode(request.getMobile(), AccountTypeEnum.SYSCODE_TYPE_RESET_PASSWORD.getCode() + "", request.getAuthCode());
        if (StringUtils.isEmpty(request.getPassword())) {
            throw new AccountException(AccountExceptionEnum.PICA_PASSWORD_ERROR);
        }
        passwordService.forgetPassword(request);
        return PicaResponse.toResponse();
    }
}
