package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.constants.Constants;
import com.pica.cloud.account.account.server.service.TokenService;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.foundation.utils.utils.CommonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.Map;
import java.util.UUID;

import static com.pica.cloud.foundation.utils.utils.json.Object2Map.objectToMapString;

/**
 * Created on 2019/9/11 13:10
 * author:crs
 * Description:获取随机token
 */
@Service
public class TokenServiceImpl implements TokenService {

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient redisClient;

    @Override
    public String getToken(Map<String, Object> headersMap) {
        String mobile = new StringBuilder("9").append(CommonUtil.getRandom(10)).toString();
        headersMap.put(Constants.HEADER_MOBILE, mobile);
        if (!CollectionUtils.isEmpty(headersMap)) {
            PicaUser picaUser = new PicaUser();
            picaUser.setCreated_time(new Date());
            picaUser.setMobile((String) headersMap.get(Constants.HEADER_MOBILE));
            picaUser.setName(Constants.HEADER_USER_TYPE);
            picaUser.setId(0);
            picaUser.setBrowser_ver((String) headersMap.get(Constants.HEADER_BROWSER));
            picaUser.setOs_name((String) headersMap.get(Constants.HEADER_OPERATOR_SYSTEM));
            picaUser.setTerminal_type((String) headersMap.get(Constants.HEADER_TERMINAL_TYPE));
            picaUser.setIp_addr((String) headersMap.get(Constants.HEADER_IP));
            try {
                Map<String, String> map = objectToMapString(Constants.TIME_FORMAT, picaUser, new String[0]);
                map.put(Constants.HEADER_SYS_CODE, Constants.HEADER_SYS_SOURCE);
                map.put(Constants.HEADER_GUEST_ID, UUID.randomUUID().toString().replace("-", "").toUpperCase());
                String token = redisClient.saveToken(map, 21600);
                return token;

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}
