package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.AesBean.AesAuthCodeReq;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.entity.LogLoginAes;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.LoginV1Service;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.account.account.server.util.RSAUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(description = "登录v1.0")
@RestController
@RequestMapping("v1/login")
public class LoginV1Controller extends AccountBaseController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private LoginV1Service loginV1Service;

    @ApiOperation(value = "统一校验(传空则不会校验)")
    @PostMapping("/unifiedVerification")
    public PicaResponse unifiedVerification(@RequestBody AesAuthCodeReq req) throws Exception {

        EncryptEntity entity = new EncryptEntity();
        entity.setKey(req.getKey());
        entity.setContent(req.getContent());

        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setSourceType(super.getSourceType());
        logger.info("v1/login/unifiedVerification:{}", JSONObject.toJSONString(request));
        loginV1Service.mobileValidate(request);
        return PicaResponse.toResponse();
    }

}
