package com.pica.cloud.account.account.server.service.impl;


import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.SourceTypeEnum;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.LoginV1Service;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.entity.PicaWarnException;
import com.pica.cloud.foundation.utils.utils.ValidateUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginV1ServiceImpl implements LoginV1Service {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AccountInfoDetailMapper accountInfoMapper;

    @Override
    public void mobileValidate(BaseRequest request) {
        Integer bizType = request.getBizType();
        String mobile = request.getMobile();
        Integer sourceType = request.getSourceType();

        // todo 报错提示 bizetype
        if (null == bizType) {
            logger.info("bizType is null");
            throw new PicaWarnException(PicaResultCode.PARAM_IS_BLANK.code(),
                    PicaResultCode.PARAM_IS_BLANK.message());
        }

        //  手机号规则校验
        if (StringUtils.isNotEmpty(mobile) &&
                !ValidateUtils.isMobile(mobile)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_MOBILE_REG_FALSE.getCode(),
                    AccountExceptionEnum.PICA_MOBILE_REG_FALSE.getMessage());
        }

        if (bizType.equals(2)) {

        } else if (bizType.equals(3)) {
            // 账户密码登录-step1-check mobile
            //  手机号是否注册
            AccountInfoEntity accountInfo = accountInfoMapper.selectByMobile(AESUtil.encryptV0(mobile));
            if (accountInfo == null) {
                throw new PicaWarnException(AccountExceptionEnum.MOBILE_NOT_REGISTER.getCode(),
                        AccountExceptionEnum.MOBILE_NOT_REGISTER.getMessage().replace("{mobile}", mobile));
            }

            //  手机号是否设置了密码
            if (StringUtils.isEmpty(accountInfo.getPassword())) {
                if (sourceType != null && SourceTypeEnum.H5.getCode().equals(sourceType)) {
                    throw new PicaWarnException(AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD_H5.getCode(),
                            AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD_H5.getMessage());
                } else {
                    throw new PicaWarnException(AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD.getCode(),
                            AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD.getMessage().replace("{mobile}", mobile));
                }
            }
        }
    }



}
