// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.common.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;


/**
 * @Author qinwh
 * @Date 2022/3/1 10:45
 */
@ApiModel
public class HospitalSaasUserReq {

    @ApiModelProperty("人员id")
    private Long id;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("机构id")
    private Integer hospitalId;

    @ApiModelProperty("机构id")
    private String hospitalName;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("备注")
    private String comment;

    @ApiModelProperty("角色id  0 无角色 1 主管理员 2 管理员 3 saas系统管理员 4 saas用户")
    private List<Long> roleId;

    @ApiModelProperty("产品类型 1.云鹊医 2.云鹊健康 3.直播 4.crm(saas注册固定写死为crm)")
    private Integer productType;

    @ApiModelProperty("资源类型 1表示安卓，2表示ios，3表示web，4表示H5登录，5表示admin后台 6.SAAS")
    private Integer sourceType;


    @ApiModelProperty("登录来源  0:运营平台 1:saas")
    private Integer loginFlag = 0;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getHospitalId() {
        return hospitalId;
    }

    public void setHospitalId(Integer hospitalId) {
        this.hospitalId = hospitalId;
    }

    public String getHospitalName() {
        return hospitalName;
    }

    public void setHospitalName(String hospitalName) {
        this.hospitalName = hospitalName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<Long> getRoleId() {
        return roleId;
    }

    public void setRoleId(List<Long> roleId) {
        this.roleId = roleId;
    }

    public Integer getProductType() {
        return productType;
    }

    public void setProductType(Integer productType) {
        this.productType = productType;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Integer getLoginFlag() {
        return loginFlag;
    }

    public void setLoginFlag(Integer loginFlag) {
        this.loginFlag = loginFlag;
    }
}
