package com.pica.cloud.account.account.server.job;

import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.foundation.redis.ICacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * Created on 2019/10/29 15:37
 * author:crs
 * Description:doctor表重复记录处理
 */
@Component
public class DoctorRepeatDataJob {
    private final String KEY = "cacheProcessDoctorRepeat";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient cacheClient;

    @Autowired
    private DoctorMapper doctorMapper;

    /**
     * 1、使用分布式锁保证一个微服务执行；
     * 2、定时任务；
     */
    @Scheduled(cron = "0 0 0/1 * * ?")
    public void processDoctorRepeatData() {
        //通过接口幂等性逻辑处理
        String exist = cacheClient.get(KEY);
        if (exist==null){
            cacheClient.set(KEY,"1");
            cacheClient.expire(KEY, 60 * 10);
            logger.info("DoctorRepeatDataJob:开始执行刷新doctor表中重复的记录");
            int row = doctorMapper.processDoctorRepeatData();
            logger.info("此次数据刷新影响的行数：{}", row);
            try {
                //防止任务一秒跑完，其他机器的时间晚了几秒
                Thread.sleep(30*1000);
            } catch (InterruptedException ex) {
                logger.error(ex.getMessage(), ex);
            }
            //释放锁
            cacheClient.del(KEY);
        }
    }
}
