package com.pica.cloud.account.account.server.service.impl;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.constants.Constants;
import com.pica.cloud.account.account.server.entity.*;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.enums.SourceTypeEnum;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.mapper.LogOneChlickCheckMapper;
import com.pica.cloud.account.account.server.model.OneClickProcessor;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.req.OneClickLoginReq;
import com.pica.cloud.account.account.server.service.LoginV1Service;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.IntactUtil;
import com.pica.cloud.account.account.server.util.TokenUtils;
import com.pica.cloud.foundation.completeness.client.utils.IntactUtils;
import com.pica.cloud.foundation.completeness.contract.constants.CommonConstants;
import com.pica.cloud.foundation.encryption.common.constants.EncryptConstants;
import com.pica.cloud.foundation.encryption.util.EncryptUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.entity.PicaWarnException;
import com.pica.cloud.foundation.message.client.EquipmentService;
import com.pica.cloud.foundation.message.common.req.DeviceReq;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.utils.ValidateUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service
public class LoginV1ServiceImpl implements LoginV1Service {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RegisterService registerService;

    @Autowired
    private OneClickProcessor oneClickProcessor;

    @Autowired
    private IntactUtil intactUtil;

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    private DoctorMapper doctorInfoMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Autowired
    private AccountInfoDetailMapper accountInfoMapper;

    @Autowired
    private ICacheClient cacheClient;

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Qualifier("accountThreadPool")
    @Autowired
    private ThreadPoolTaskExecutor poolTaskExecutor;

    @Autowired
    private LogOneChlickCheckMapper logOneChlickCheckMapper;

    @Autowired
    private EquipmentService equipmentService;

    /**
     * 新版一键登录
     *
     * @param req
     * @return
     */
    @Override
    public LoginResult oneClickLoginV1(OneClickLoginReq req) {
        QueryMobileEntity queryMobileEntity = oneClickProcessor.tokenExchangeMobile(req.getToken(), req.getSourceType());
        if (queryMobileEntity == null || StringUtils.isBlank(queryMobileEntity.getMobile()) || !ValidateUtils.isMobile(queryMobileEntity.getMobile())) {
            logger.error("oneClickLoginV1 闪验获取出错-queryMobileEntity:{}", JSONObject.toJSONString(queryMobileEntity));
            throw new PicaException(PicaResultCode.INTERFACE_INVOKE_EXCEPTION.code(), "获取手机号失败！");
        }

        queryMobileEntity.setSourceType(req.getSourceType());
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(AESUtil.encryptV0(queryMobileEntity.getMobile()));
        BaseRequest baseRequest = new BaseRequest();
        baseRequest.setMobile(queryMobileEntity.getMobile());
        baseRequest.setSourceType(req.getSourceType());
        baseRequest.setProductType(req.getProductType());
        baseRequest.setLoginIp(req.getLoginIp());
        baseRequest.setUserTokenTourist(req.getUserTokenTourist());

        LoginResult result;
        if (accountInfoEntity == null) {
            //说明是注册功能
            result = registerService.register(baseRequest, queryMobileEntity);
        } else {
            String deviceToken = req.getDeviceToken();
            logger.info("oneClickLoginV1-用户传入的deviceToken为{}", JSONObject.toJSONString(baseRequest));
            if (StringUtils.isEmpty(deviceToken)) {
                throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), PicaResultCode.PARAM_IS_BLANK.message());
            }

            // 根据deviceToken获取该设备上一次登录的手机号
            Integer userId = getUserId(deviceToken);
            logger.info("oneClickLoginV1-该设备上次登录的用户id为：{}", userId);
            logger.info("oneClickLoginV1-accountInfoEntity, {}", JSONObject.toJSONString(accountInfoEntity));

            if (req.getCheckFlag()) {
                // 直接登录，不需要校验手机号(点击了继续一键登录)
                logger.info("oneClickLoginV1-用户直接登录, {}", JSONObject.toJSONString(baseRequest));
                result = processLoginV1(baseRequest, accountInfoEntity.getId(), AccountTypeEnum.LOGIN_ONE_CLICK.getCode(), queryMobileEntity);

                // 记录继续一键登录日志
                Map<String, String> param = new HashMap();
                param.put("req", JSONObject.toJSONString(req));
                param.put("queryMobileEntity", JSONObject.toJSONString(queryMobileEntity));
                param.put("accountInfoEntity", JSONObject.toJSONString(accountInfoEntity));
                param.put("baseRequest", JSONObject.toJSONString(baseRequest));
                poolTaskExecutor.execute(() -> insertLog(userId, queryMobileEntity.getMobile(), deviceToken, param.toString()));
            } else {
                // 第一次点"一键登录"接口，需要比对上次登录的手机号与这次是否一样
                if (userId == null) {
                    // 直接登录
                    result = processLoginV1(baseRequest, accountInfoEntity.getId(), AccountTypeEnum.LOGIN_ONE_CLICK.getCode(), queryMobileEntity);
                } else {
                    // 根据userId获取手机号
                    PICAPDoctor doctor = doctorInfoMapper.queryDoctor(userId);
                    if (doctor == null) {
                        // 医生被删掉了，直接登录
                        result = processLoginV1(baseRequest, accountInfoEntity.getId(), AccountTypeEnum.LOGIN_ONE_CLICK.getCode(), queryMobileEntity);
                    } else {
                        String mobilePhone = doctor.getMobile_phone();
                        mobilePhone = EncryptUtils.decryptContent(mobilePhone, EncryptConstants.ENCRYPT_TYPE_MOBILE, EncryptConstants.ENCRYPT_DECRYPT_KEY);
                        if (queryMobileEntity.getMobile().equals(mobilePhone)) {
                            // 手机号匹配，直接登录
                            result = processLoginV1(baseRequest, accountInfoEntity.getId(), AccountTypeEnum.LOGIN_ONE_CLICK.getCode(), queryMobileEntity);
                        } else {
                            // 该设备本次登录手机号与上次登录手机号不是同一手机号，需用户进行确认
                            result = new LoginResult();
                            result.setCheckStatus(false);
                            result.setSuggestMessage("为保证学习记录完整，建议使用同一手机号进行登录");

                            String begin = mobilePhone.substring(0, 3);
                            String end = mobilePhone.substring(7, 11);
                            String last = begin + "****" + end;
                            String differentMessage = "当前设备上次使用" + last + "登录";
                            result.setDifferentMessage(differentMessage);
                        }
                    }
                }
            }

        }
        return result;
    }

    @Override
    public void insertLog(Integer userId, String currMobilePhone, String deviceToken, String keepBack) {
        logger.info("oneClickLoginV1-继续一键登录日志入库");
        // 获取上一次登录的手机号
        String lastMobilePhone = "";
        PICAPDoctor doctor = doctorInfoMapper.queryDoctor(userId);
        if (doctor != null) {
            lastMobilePhone = doctor.getMobile_phone();
        }
        // 加密当前手机号
        currMobilePhone = EncryptUtils.encryptContent(currMobilePhone, EncryptConstants.ENCRYPT_TYPE_MOBILE);

        LogOneChlickCheck logOneChlickCheck = new LogOneChlickCheck();
        logOneChlickCheck.setCreatedId(99999999);
        logOneChlickCheck.setModifiedId(99999999);
        Date now = new Date();
        logOneChlickCheck.setCreatedTime(now);
        logOneChlickCheck.setModifiedTime(now);
        logOneChlickCheck.setCurrMobilePhone(currMobilePhone);
        logOneChlickCheck.setLastMobilePhone(lastMobilePhone);
        logOneChlickCheck.setDeleteFlag((byte) 1);
        logOneChlickCheck.setUsedShanyan(true);
        logOneChlickCheck.setDeviceToken(deviceToken);
        logOneChlickCheck.setKeepBack(keepBack);
        logger.info("oneClickLoginV1-继续一键登录日志入库，{}", JSONObject.toJSONString(logOneChlickCheck));
        logOneChlickCheckMapper.insertOne(logOneChlickCheck);
        logger.info("oneClickLoginV1-继续一键登录日志入库完成");
    }

    private Integer getUserId(String deviceToken) {
        Integer userId = null;
        try {
            DeviceReq req = new DeviceReq();
            req.setDeviceToken(deviceToken);
            PicaResponse<Integer> response= equipmentService.getUserIdByDeviceToken(req);
            userId = response.getData();
        } catch (Exception e) {
            // 防止message服务出问题影响一键登录流程
            logger.error("getUserId-调用message服务出错！");
            e.printStackTrace();
        }
        return userId;
    }

    private LoginResult processLoginV1(BaseRequest baseRequest, Integer acctId, Integer loginType, QueryMobileEntity queryMobileEntity) {
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo, "processLoginV1", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1, "baseRequest:" + JSON.toJSONString(baseRequest) + ",+acctId:" + acctId + ",loginType:" + loginType + ",queryMobileEntity:" + JSON.toJSONString(queryMobileEntity));
        Date currentTime = new Date();
        Long userId = accountUtils.getUserIdByAcctId(baseRequest.getProductType(), acctId);
        Account account = new Account();
        account.setId(userId);
        account.setAcctId(acctId);
        account.setCreatTime(currentTime);
        account.setMobilePhone(baseRequest.getMobile());
        account.setRegisterSource(baseRequest.getSourceType());
        String newToken = tokenUtils.generateToken(account);
        LoginResult result = new LoginResult();
        result.setToken(newToken);
        result.setUserId(userId);
        result.setMobile(baseRequest.getMobile());
        result.setDoctorId(EncryptUtils.encryptContent(userId + "", EncryptConstants.ENCRYPT_TYPE_ID));
        //是否完善过个人信息（云鹊医app才需要）
        if (baseRequest.getProductType() != AccountTypeEnum.PRODUCT_TYPE_HEALTH.getCode()) {
            Doctor doctorEntity = doctorInfoMapper.selectByPrimaryKey(userId.intValue());
            result.setEntireFlag(doctorEntity.getEntireFlag());
        }
        //记录登录日志
        LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, baseRequest.getProductType(), baseRequest.getSourceType(),
                loginType, baseRequest.getLoginIp(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(), AccountTypeEnum.LOG_TYPE_LOGIN.getCode(), newToken, 1, baseRequest.getUserTokenTourist());
        if (queryMobileEntity != null) {
            entity.setQueryMobileEntity(queryMobileEntity);
        }
        picaLogUtils.info(entity);
        intactUtil.sendIntact(batchNo, "processLoginV1", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3, "baseRequest:" + JSON.toJSONString(baseRequest) + ",+acctId:" + acctId + ",loginType:" + loginType + ",queryMobileEntity:" + JSON.toJSONString(queryMobileEntity));

        return result;
    }

    /**
     * 手机号 统一check
     *
     * @param request
     */
    @Override
    public void mobileValidate(BaseRequest request) {
        Integer bizType = request.getBizType();
        String mobile = request.getMobile();
        Integer sourceType = request.getSourceType();

        if (null == bizType) {
            logger.info("bizType is null");
            throw new PicaWarnException(AccountExceptionEnum.PARAMS_BIZ_TYPE_EMPTY.getCode(),
                    AccountExceptionEnum.PARAMS_BIZ_TYPE_EMPTY.getMessage());
        }

        //  手机号规则校验
        if (StringUtils.isNotEmpty(mobile) &&
                !ValidateUtils.isMobile(mobile)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_MOBILE_REG_FALSE.getCode(),
                    AccountExceptionEnum.PICA_MOBILE_REG_FALSE.getMessage());
        }

        if (bizType.equals(3)) {
            // 账户密码登录-step1-check mobile
            //  手机号是否注册
            AccountInfoEntity accountInfo = accountInfoMapper.selectByMobile(AESUtil.encryptV0(mobile));
            if (accountInfo == null) {
                throw new PicaWarnException(AccountExceptionEnum.MOBILE_NOT_REGISTER.getCode(),
                        AccountExceptionEnum.MOBILE_NOT_REGISTER.getMessage().replace("{mobile}", mobile));
            }

            //  手机号是否设置了密码
            if (StringUtils.isEmpty(accountInfo.getPassword())) {
                if (sourceType != null && SourceTypeEnum.H5.getCode().equals(sourceType)) {
                    throw new PicaWarnException(AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD_H5.getCode(),
                            AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD_H5.getMessage());
                } else {
                    throw new PicaWarnException(AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD.getCode(),
                            AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD.getMessage().replace("{mobile}", mobile));
                }
            }
        }
    }

    /**
     * v1 账户密码登录
     *
     * @param request
     * @return
     */
    @Override
    public LoginResult v1LoginPassword(BaseRequest request) {

        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo, "v1LoginPassword", CommonConstants.INTACT_CONTENT_LOG_STATUS_1, "request:" + JSON.toJSONString(request));

        String mobile = request.getMobile();
        Integer sourceType = request.getSourceType();
        String encrypt = AESUtil.encryptV0(mobile);
        AccountInfoEntity accountInfoEntity = accountInfoMapper.selectByMobile(encrypt);
        Doctor doctorInfo = doctorInfoMapper.getDoctorInfoByMobile(encrypt);
        if (null == accountInfoEntity || null == doctorInfo) {
            intactUtil.sendIntact(batchNo, "v1LoginPassword", CommonConstants.INTACT_CONTENT_LOG_STATUS_3, "手机号" + mobile + "尚未注册");
            throw new PicaWarnException(AccountExceptionEnum.MOBILE_NOT_REGISTER.getCode(),
                    AccountExceptionEnum.MOBILE_NOT_REGISTER.getMessage().replace("{mobile}", mobile));
        } else {
            String oldPwd = accountInfoEntity.getPassword();
            String password = request.getPassword();
            // db中账户 未设置密码
            if (StringUtils.isEmpty(oldPwd)) {
                if (sourceType != null && SourceTypeEnum.H5.getCode().equals(sourceType)) {
                    intactUtil.sendIntact(batchNo, "v1LoginPassword", CommonConstants.INTACT_CONTENT_LOG_STATUS_3,
                            AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD_H5.getMessage());
                    throw new PicaWarnException(AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD_H5.getCode(),
                            AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD_H5.getMessage());
                } else {
                    intactUtil.sendIntact(batchNo, "v1LoginPassword", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3,
                            AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD.getMessage().replace("{mobile}", mobile));
                    throw new PicaException(AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD.getCode(),
                            AccountExceptionEnum.PICA_MOBILE_NOT_SETED_PASSWORD.getMessage()
                                    .replace("{mobile}", mobile));
                }
            }

            //  判断账号是否已锁
            checkMobileIsLocked(mobile, sourceType, batchNo, "v1LoginPassword");

            if (!password.equals(oldPwd)) {
                //登录密码错误，次数计数、存cache
                checkMobileErrorPasswordLogin(mobile, sourceType, batchNo, "v1LoginPassword");
            } else {
                intactUtil.sendIntact(batchNo, "v1LoginPassword", CommonConstants.INTACT_CONTENT_LOG_STATUS_3, "接下来调用pwdLoginCorrect");
                //密码登录-密码正确逻辑
                return v1PwdLoginCorrect(request,mobile,doctorInfo);
            }
        }
        return null;
    }

    /**
     * ------------------- private -------------------
     */

    /**
     * 判断账号是否已锁
     *
     * @param mobile
     */
    private void checkMobileIsLocked(String mobile, Integer sourceType, String batchNo, String batchMethod) {
        String lockKey = Constants.ACCOUNT_LOCK_KEY.replace("{mobile}", mobile);
        if (cacheClient.exists(lockKey)) {
            if (sourceType != null && SourceTypeEnum.H5.getCode().equals(sourceType)) {
                intactUtil.sendIntact(batchNo, batchMethod, CommonConstants.INTACT_CONTENT_LOG_STATUS_3,
                        AccountExceptionEnum.PICA_PWD_MISMATCH_5_H5.getMessage());

                throw new PicaException(AccountExceptionEnum.PICA_PWD_MISMATCH_5_H5.getCode(),
                        AccountExceptionEnum.PICA_PWD_MISMATCH_5_H5.getMessage());
            } else {
                intactUtil.sendIntact(batchNo, batchMethod, CommonConstants.INTACT_CONTENT_LOG_STATUS_3,
                        AccountExceptionEnum.PICA_PWD_MISMATCH_5.getMessage().replace("{mobile}", mobile));

                throw new PicaException(AccountExceptionEnum.PICA_PWD_MISMATCH_5.getCode(),
                        AccountExceptionEnum.PICA_PWD_MISMATCH_5.getMessage().replace("{mobile}", mobile));
            }
        }
    }


    /**
     * @param mobile
     * @param sourceType
     * @param batchNo
     * @param batchMethod
     */
    private void checkMobileErrorPasswordLogin(String mobile, Integer sourceType, String batchNo, String batchMethod) {
        String lockKey = Constants.ACCOUNT_LOCK_KEY.replace("{mobile}", mobile);
        String errorKey = Constants.PWD_ERROR_NUM_KEY.replace("{mobile}", mobile);
        if (cacheClient.exists(errorKey)) {
            int errorCount = Integer.parseInt(cacheClient.get(errorKey));
            errorCount = errorCount + 1;
            cacheClient.set(errorKey, errorCount, Constants.PWD_ERROR_NUM_SECONDS);
            if (errorCount <= 4) {
                intactUtil.sendIntact(batchNo, batchMethod, CommonConstants.INTACT_CONTENT_LOG_STATUS_3,
                        AccountExceptionEnum.PICA_PWD_MISMATCH_4.getMessage());
                throw new PicaException(AccountExceptionEnum.PICA_PWD_MISMATCH_4.getCode(),
                        AccountExceptionEnum.PICA_PWD_MISMATCH_4.getMessage());
            } else {
                //  设置账号锁定24h
                cacheClient.set(lockKey, mobile, Constants.PWD_ERROR_NUM_SECONDS);
                if (sourceType != null && SourceTypeEnum.H5.getCode().equals(sourceType)) {
                    intactUtil.sendIntact(batchNo, batchMethod, CommonConstants.INTACT_CONTENT_LOG_STATUS_3,
                            AccountExceptionEnum.PICA_PWD_MISMATCH_5_H5.getMessage());
                    throw new PicaException(AccountExceptionEnum.PICA_PWD_MISMATCH_5_H5.getCode(),
                            AccountExceptionEnum.PICA_PWD_MISMATCH_5_H5.getMessage());
                } else {
                    intactUtil.sendIntact(batchNo, batchMethod, CommonConstants.INTACT_CONTENT_LOG_STATUS_3,
                            AccountExceptionEnum.PICA_PWD_MISMATCH_5.getMessage().replace("{mobile}", mobile));
                    throw new PicaException(AccountExceptionEnum.PICA_PWD_MISMATCH_5.getCode(),
                            AccountExceptionEnum.PICA_PWD_MISMATCH_5.getMessage().replace("{mobile}", mobile));
                }
            }
        } else {
            cacheClient.set(errorKey, 1, Constants.PWD_ERROR_NUM_SECONDS);
            intactUtil.sendIntact(batchNo, batchMethod, CommonConstants.INTACT_CONTENT_LOG_STATUS_3,
                    AccountExceptionEnum.PICA_PWD_MISMATCH_4.getMessage());
            throw new PicaException(AccountExceptionEnum.PICA_PWD_MISMATCH_4.getCode(),
                    AccountExceptionEnum.PICA_PWD_MISMATCH_4.getMessage());
        }
    }

    /**
     * @Description 密码登录-密码正确逻辑
     */
    private LoginResult v1PwdLoginCorrect(BaseRequest request, String mobile, Doctor doctor) {
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo, "v1PwdLoginCorrect", CommonConstants.INTACT_CONTENT_LOG_STATUS_1, "baseRequest:" + JSON.toJSONString(request));
        Date currentTime = new Date();
        Integer acctId = doctor.getAcctId();
        int productType = request.getProductType();
        int sourceType = request.getSourceType();
        Integer userId = doctor.getId();
        Account account = new Account();
        account.setId(userId.longValue());
        account.setAcctId(acctId);
        account.setCreatTime(currentTime);
        account.setMobilePhone(mobile);
        account.setRegisterSource(sourceType);
        String newToken = tokenUtils.generateToken(account);
        LoginResult result = new LoginResult();
        result.setToken(newToken);
        result.setUserId(userId.longValue());
        result.setMobile(mobile);
        result.setDoctorId(EncryptUtils.encryptContent(userId + "", EncryptConstants.ENCRYPT_TYPE_ID));
        result.setEntireFlag(doctor.getEntireFlag());

        LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, productType, sourceType,
                AccountTypeEnum.LOGIN_PWD.getCode(), request.getLoginIp(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(),
                AccountTypeEnum.LOG_TYPE_LOGIN.getCode(), newToken, 1, request.getUserTokenTourist());
        picaLogUtils.info(entity);

        //  密码登录成功以后，清除错误次数记录
        String pwdErrorNum = Constants.PWD_ERROR_NUM_KEY.replace("{mobile}", mobile);
        if (cacheClient.exists(pwdErrorNum)) {
            cacheClient.del(pwdErrorNum);
        }
        intactUtil.sendIntact(batchNo, "v1PwdLoginCorrect", CommonConstants.INTACT_CONTENT_LOG_STATUS_3, "baseRequest:" + JSON.toJSONString(request));

        return result;
    }

}
