// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.service.ProtocolService;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.patient.smartcontract.common.req.BatchSignReq;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @ClassName ProtocolController
 * @Description 协议相关
 * @Author Chongwen.jiang
 * @Date 2020/2/20 10:48
 * @ModifyDate 2020/2/20 10:48
 * @Version 1.0
 */
@Api(description = "协议相关")
@RequestMapping("/protocol")
@RestController
public class ProtocolController extends AccountBaseController {

    @Autowired
    private ProtocolService protocolService;

    @ApiOperation(value = "批量查询指定类型协议")
    @GetMapping("/names")
    public PicaResponse get(){
        return PicaResponse.toResponse(
                protocolService.getProtocolNames());
    }

    @ApiOperation(value = "首次唤起App签订协议")
    @PostMapping("/firstCallApp")
    public PicaResponse firstCallApp(@RequestBody BatchSignReq req){
        String appVersion = super.getDeviceInfo("app_version");
        req.setUserId(Integer.parseInt(String.valueOf(super.getDoctorIdByToken())));
        protocolService.firstCallAppSignProtocol(req, appVersion);
        return PicaResponse.toResponse();
    }

}
