package com.pica.cloud.account.account.client;

import com.pica.cloud.account.account.common.req.*;
import com.pica.cloud.account.account.common.req.circle.CircleAcctInitReq;
import com.pica.cloud.account.account.common.req.shop.ShopAcctInitReq;
import com.pica.cloud.foundation.entity.PicaResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

import java.util.List;
import java.util.Map;

/**
 * Created on 2019/10/16 17:28
 * author:crs
 * Description:RegisterClient
 */
@FeignClient(name = "13201-pica-cloud-account")
public interface RegisterClient {

    @PostMapping(value = "/account/register")
    PicaResponse<LoginResult> register(@RequestBody EncryptEntity entity);

    @PostMapping(value = "/account/register/ocin")
    PicaResponse register(@RequestBody OCINRequest ocinRequest);

    @PostMapping(value = "/account/circle/acct")
    PicaResponse<List<Integer>> register(@RequestBody CircleAcctInitReq circleAcctInitReq, @RequestHeader(value = "token") String token);

    @PostMapping(value = "/account/circle/acct/followup")
    PicaResponse<List<DocInfoResp>> registerFollowup(@RequestBody List<DocInfoReq> req, @RequestHeader(value = "token") String token);

    @PostMapping(value = "/account/shop/acct")
    PicaResponse<Map<String,Integer>> shopRegister(@RequestBody ShopAcctInitReq shopAcctInitReq, @RequestHeader(value = "token") String token);

    @PostMapping("/account/account/login-register/v1")
    PicaResponse<LoginResult> loginRegister(@RequestBody EncryptEntity entity);

    @PostMapping("/account/saas/hospital/registerV2")
    PicaResponse<Integer> registerV2(@RequestBody HospitalSaasUserReq req, @RequestHeader(value = "token") String token);

    @PostMapping("/account/saas/hospital/upsertV2")
    PicaResponse<Integer> upsertV2(@RequestBody HospitalSaasUserReq req,@RequestHeader(value = "token") String token);
}