package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.common.req.AccountInfoReq;
import com.pica.cloud.account.account.common.resp.DoctorUnionResp;
import com.pica.cloud.account.account.server.entity.AccountWeChatInfoEntity;
import com.pica.cloud.account.account.server.service.AccountInfoService;
import com.pica.cloud.account.account.server.service.WechatService;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.service.starter.interceptor.EnabledLoginValidate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author andong
 * @create 2019/7/18
 */
@Api(description = "账号信息")
@RestController
@RequestMapping("/info")
public class AccountInfoController extends AccountBaseController {

    @Autowired
    private AccountInfoService accountInfoService;

    @Autowired
    private WechatService wechatService;

    @ApiOperation("获取用户数量")
    @PostMapping("/count")
    public PicaResponse<Integer> getCount(@RequestBody AccountInfoReq req) {
        if (req == null || (req.getProvinceId() == null && req.getCityId() == null && req.getCountyId() == null
                && CollectionUtils.isEmpty(req.getTitleIds()) && CollectionUtils.isEmpty(req.getLevelGrades()))) {
            return PicaResponse.toResponse(accountInfoService.getTotalCount());
        }
        return PicaResponse.toResponse(accountInfoService.getCount(req));
    }

    @ApiOperation("获取医生ID列表")
    @PostMapping("/doctorIds")
    public PicaResponse<List<Integer>> getDoctorIds(@RequestBody AccountInfoReq req) {
        if (req == null || (req.getProvinceId() == null && req.getCityId() == null && req.getCountyId() == null
                && CollectionUtils.isEmpty(req.getTitleIds()) && CollectionUtils.isEmpty(req.getLevelGrades()))) {
            return PicaResponse.toResponse(Collections.emptyList());
        }
        return PicaResponse.toResponse(accountInfoService.getDoctorIds(req));
    }

    @ApiOperation("获取医生wechat信息")
    @GetMapping("/wechat")
    @EnabledLoginValidate
    public PicaResponse<AccountWeChatInfoEntity> getWechatInfo(@RequestHeader String token) {

        return PicaResponse.toResponse(wechatService.getAccountWechatInfo(fetchPicaUser()));
    }

    @ApiOperation("批量获取医生wechat信息")
    @PostMapping("/wechat/batch")
    public PicaResponse<Map<Integer,String>> getWechatInfoBatch(@RequestBody List<Integer> docIds) {

        return PicaResponse.toResponse(wechatService.getAccountWechatInfoBatch(docIds));
    }

    @ApiOperation(value = "根据unionid查看个人认证信息")
    @GetMapping(value = "/doctor/union", produces = "application/json;charset=UTF-8")
    public PicaResponse<DoctorUnionResp> getDoctorByUnionid(@RequestParam(value = "unionid") String unionid) {

        DoctorUnionResp personalInfoDto = wechatService.getDoctorByUnionid(unionid);
        return PicaResponse.toResponse(personalInfoDto);
    }
}
