package com.pica.cloud.account.account.client;

import com.pica.cloud.account.account.common.req.*;
import com.pica.cloud.account.account.common.resp.*;
import com.pica.cloud.foundation.entity.PicaResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@FeignClient(name = "13201-pica-cloud-account")
public interface PatHealthPackClient {

    @GetMapping(value = "/account/pat-health/acctId/unionId/{unionId}")
    PicaResponse<Integer> getAcctIdByUnionId(@PathVariable("unionId") String unionId);

    @GetMapping(value = "/account/pat-health/unionId/acctId/{acctId}")
    PicaResponse<Integer> getUnionIdByAcctId(@PathVariable("acctId") Integer acctId);

    @GetMapping(value = "/account/pat-health/acctId/patId/{patientId}")
    PicaResponse<Integer> getAcctIdByPatId(@PathVariable("patientId") Integer patientId);

    @GetMapping(value = "/account/pat-health/directPatIds/{patientId}")
    PicaResponse<List<Integer>> getDirectPatIdsByPatId(@PathVariable("patientId") Integer patientId);

    @GetMapping(value = "/account/pat-health/familyPats/{acctId}/containAcct/{containAcct}")
    PicaResponse<PatFamilyResp> getFamilyPatsByAcctId(@PathVariable("acctId") Integer acctId, @PathVariable("containAcct") Integer containAcct);

    @PostMapping(value = "/account/pat-health/acct")
    PicaResponse<Integer> saveAcct(@RequestBody AcctPatInfoReq patInfoReq);

    @PostMapping(value = "/account/pat-health/acct/bindUnion")
    PicaResponse<PatBindResp> bindUnion(@RequestBody AcctPatInfoReq patInfoReq);

    @PostMapping(value = "/account/pat-health/family/member")
    PicaResponse<PatFamilyResp> saveMember(@RequestBody AcctPatFamilyReq familyReqReq);

    @GetMapping(value = "/account/pat-health/familyAcct/patId/{patId}")
    PicaResponse<Integer> getFamilyAcctPatId(@PathVariable("patId") Integer patId);

    @GetMapping(value = "/account/pat-health/familyAcct/self/patId/{patId}")
    PicaResponse<List<Integer>> getRelationSelfAcctPatId(@PathVariable("patId") Integer patId);

    @PostMapping(value = "/account/pat-health/familyAcct/patIds")
    PicaResponse<AcctPatIdResp> getFamilyAcctPatIds(@RequestBody AcctPatIdReq acctPatIdReq);

    @PostMapping(value = "/account/pat-health/init/accts")
    PicaResponse initAccts(@RequestBody List<InitAcctReq> initAcctReqList);

    @PostMapping(value = "/account/pat-health/patIds/query/page")
    PicaResponse<List<Integer>> queryByPage(@RequestBody AcctPatPageReq patPageReq);

    @GetMapping(value = "/account/pat-health/mobile/{mobile}")
    PicaResponse<AcctSelfPatId> getAcctIdByMobile(@PathVariable("mobile") String mobile);

    @PostMapping(value = "/account/pat-health/family/unusual/record")
    PicaResponse saveUnusualFamilyRecord(@RequestBody PatFamilyRecordReq patFamilyRecordReq);

    @PostMapping(value = "/account/pat-health/acct/updatePatByAcctId")
    PicaResponse<Boolean> updatePatByAcctId(@RequestBody UpdateAcctPatInfoReq req);

    @GetMapping(value = "/account/pat-health/acctInfo/patId/{patientId}")
    PicaResponse<AcctSelfPatInfoResp> getAcctInfoByPatId(@PathVariable("patientId") Integer patientId);

}
