// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.common.req.*;
import com.pica.cloud.account.account.common.resp.*;
import com.pica.cloud.account.account.server.service.AccountPatFamilyRecordService;
import com.pica.cloud.account.account.server.service.PatHealthPackService;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description TODO
 * @Author peijun.zhao
 * @Date 2020/5/12 15:55
 * @ModifyDate 2020/5/12 15:55
 * @Params
 * @Return
 */
@Api(description = "健康包")
@RestController
@RequestMapping("/pat-health")
public class PatHealthPackController {

    @Autowired
    private PatHealthPackService packService;

    @Autowired
    private AccountPatFamilyRecordService accountPatFamilyRecordService;

    @ApiOperation("获取主账户ID-根据unionId")
    @GetMapping(value = "/acctId/unionId/{unionId}")
    public PicaResponse<Integer> getAcctIdByUnionId(@PathVariable("unionId") String unionId) throws Exception {
        return PicaResponse.toResponse(packService.getAcctIdByUnionId(unionId));
    }

    @ApiOperation("获取unionId-根据主账户ID")
    @GetMapping(value = "/unionId/acctId/{acctId}")
    public PicaResponse<Integer> getUnionIdByAcctId(@PathVariable("acctId") Integer acctId) throws Exception {
        return PicaResponse.toResponse(packService.getUnionIdByAcctId(acctId));
    }

    @ApiOperation("获取主账户ID-作为监护人自身patientId")
    @GetMapping(value = "/acctId/patId/{patientId}")
    public PicaResponse<Integer> getAcctIdByPatId(@PathVariable("patientId") Integer patientId) throws Exception {
        return PicaResponse.toResponse(packService.getAcctIdByPatId(patientId));
    }

    @ApiOperation("所在家庭组的监护人 + 同级家庭成员 + 下级所有成员 patientId list，去除自身、去重；")
    @GetMapping(value = "/directPatIds/{patientId}")
    public PicaResponse<List<Integer>> getDirectPatIdsByPatId(@PathVariable("patientId") Integer patientId) throws Exception {
        return PicaResponse.toResponse(packService.getDirectPatIdsByPatId(patientId));
    }

    @ApiOperation("根据accid获取自身家庭成员List;containAcct:0 包含自身 1 不包含自身")
    @GetMapping(value = "/familyPats/{acctId}/containAcct/{containAcct}")
    public PicaResponse<PatFamilyResp> getFamilyPatsByAcctId(@PathVariable("acctId") Integer acctId, @PathVariable("containAcct") Integer containAcct) throws Exception {
        return PicaResponse.toResponse(packService.getFamilyPatsByAcctId(acctId, containAcct));
    }

    @ApiOperation("保存主账户")
    @PostMapping(value = "/acct")
    public PicaResponse<Integer> saveAcct(@RequestBody AcctPatInfoReq patInfoReq) throws Exception {
        return PicaResponse.toResponse(packService.saveAcct(patInfoReq));
    }

    @ApiOperation("建立微信与账号关联关系")
    @PostMapping(value = "/acct/bindUnion")
    public PicaResponse<PatBindResp> bindUnion(@RequestBody AcctPatInfoReq patInfoReq) throws Exception {
        return PicaResponse.toResponse(packService.bindUnion(patInfoReq));
    }

    @ApiOperation("建立家庭服务关系")
    @PostMapping(value = "/family/member")
    public PicaResponse<PatFamilyResp> saveMember(@RequestBody AcctPatFamilyReq familyReqReq) throws Exception {
        return PicaResponse.toResponse(packService.saveMember(familyReqReq));
    }


    @ApiOperation("根据patientId获取监护人-本人监护人（自身patId），本人成员（监护人patId）")
    @GetMapping(value = "/familyAcct/patId/{patId}")
    public PicaResponse<Integer> getFamilyAcctPatId(@PathVariable("patId") Integer patId) throws Exception {
        return PicaResponse.toResponse(packService.getFamilyAcctPatId(patId));
    }


    @ApiOperation("根据patientId获取监护人acctId），本人成员（监护人patId）")
    @GetMapping(value = "/familyAcct/self/patId/{patId}")
    public PicaResponse<List<Integer>> getRelationSelfAcctPatId(@PathVariable("patId") Integer patId) throws Exception {
        return PicaResponse.toResponse(packService.getFamilyAcctIdsPatId(patId));
    }

    @ApiOperation("根据patientIds 获取监护人-本人监护人（自身patId），本人成员（监护人patId）")
    @PostMapping(value = "/familyAcct/patIds")
    public PicaResponse<AcctPatIdResp> getFamilyAcctPatIds(@RequestBody AcctPatIdReq acctPatIdReq) throws Exception {
        return PicaResponse.toResponse(packService.getFamilyAcctPatIds(acctPatIdReq));
    }

    @ApiOperation("初始主账户数据")
    @PostMapping(value = "/init/accts")
    public PicaResponse initAccts(@RequestBody List<InitAcctReq> initAcctReqList) throws Exception {
        return PicaResponse.toResponse(packService.initAccts(initAcctReqList));
    }

    @ApiOperation("分页查询patIds")
    @PostMapping(value = "/patIds/query/page")
    public PicaResponse<List<Integer>> queryByPage(@RequestBody AcctPatPageReq patPageReq) throws Exception {
        return PicaResponse.toResponse(packService.queryByPage(patPageReq));
    }

    @ApiOperation("根据手机号获取数据账号id和本人居民id")
    @GetMapping(value = "/mobile/{mobile}")
    public PicaResponse<AcctSelfPatId> getAcctIdByMobile(@PathVariable("mobile") String mobile) {
        return PicaResponse.toResponse(packService.getAcctIdByMobile(mobile));
    }

    @ApiOperation("存储存在问题的家庭关系")
    @PostMapping(value = "/family/unusual/record")
    public PicaResponse saveUnusualFamilyRecord(@RequestBody PatFamilyRecordReq patFamilyRecordReq) {
        accountPatFamilyRecordService.saveRecord(patFamilyRecordReq);
        return PicaResponse.toResponse();
    }

    @ApiOperation("更新accId 对应的患者信息")
    @PostMapping(value = "/acct/updatePatByAcctId")
    public PicaResponse<Boolean> updatePatByAcctId(@RequestBody UpdateAcctPatInfoReq req) {

        return PicaResponse.toResponse(packService.updatePatByAcctId(req));
    }

    @ApiOperation("获取主账户-作为监护人自身patientId")
    @GetMapping(value = "/acctInfo/patId/{patientId}")
    public PicaResponse<AcctSelfPatInfoResp> getAcctInfoByPatId(@PathVariable("patientId") Integer patientId) throws Exception {
        return PicaResponse.toResponse(packService.getAcctInfoByPatId(patientId));
    }

    @ApiOperation("更新accId 对应的患者信息")
    @PostMapping(value = "/acct/updateAcct")
    public PicaResponse updatePat(@RequestBody UpdateAcctPatInfoReq req) {
        packService.updatePat(req);
        return PicaResponse.toResponse();
    }
}
