package com.pica.cloud.account.account.server.mapper;

import com.pica.cloud.account.account.server.entity.AcctPatFamily;

import java.util.List;

public interface AcctPatFamilyMapper {
    int deleteByPrimaryKey(Integer id);

    int insert(AcctPatFamily record);

    int insertSelective(AcctPatFamily record);

    AcctPatFamily selectByPrimaryKey(Integer id);

    int updateByPrimaryKeySelective(AcctPatFamily record);

    int updateByPrimaryKey(AcctPatFamily record);

    /** 获取居民id是本人的家庭组记录- 作为家庭主账户、本人居民id，单条ok 多条异常数据 */
    AcctPatFamily getByPatIdSelf(Integer patId);

    /** 查询居民id所在家庭组监护人- 作为家庭成员、非主账户本人居民id，单条ok 多条异常数据 */
    AcctPatFamily getByPatIdNotSelf(Integer patId);

    /** 获取主账户下所有家庭成员 */
    List<AcctPatFamily> getListByAcctId(Integer acctId);

    /** 根据账户id 获取主账户居民 */
    AcctPatFamily getSelfByAcctId(Integer acctId);

    List<AcctPatFamily> getListByPatIds(List<Integer> patIds);

    List<AcctPatFamily> getByPatIdSelfList(List<Integer> patIds);

    int initBatch(List<AcctPatFamily> list);

    List<AcctPatFamily> getMemberListByPatIds(List<Integer> patIds);

}