package com.pica.cloud.account.account.server.enums;

/**
 * @Description 统一校验业务类型枚举类
 * @Author Chongwen.jiang
 * @Date 2020/2/20 18:19
 * @ModifyDate 2020/2/20 18:19
 * @Params
 * @Return
 */
public enum BizTypeEnum {

    LOGIN_AUTH_CODE(1, "验证码登录"),
    LOGIN_PWD(2, "密码登录"),
    FIND_PASSWORD(3, "找回密码"),
    LOGIN_WE_CHAT(4, "微信登录"),
    LOGIN_APPLE(5, "苹果登录"),

    XXX(10, "xxxxxx");

    private Integer code;
    private String type;

    BizTypeEnum(Integer code, String type) {
        this.code = code;
        this.type = type;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
