//// Copyright 2016-2101 Pica.
//package com.pica.cloud.account.account.server.service.impl;
//
//import com.alibaba.fastjson.JSON;
//import com.pica.cloud.account.account.server.service.ProtocolService;
//import com.pica.cloud.foundation.entity.PicaResponse;
//import com.pica.cloud.foundation.entity.PicaResultCode;
//import com.pica.cloud.foundation.entity.PicaWarnException;
//import com.pica.cloud.patient.smartcontract.client.SmartContractClient;
//import com.pica.cloud.patient.smartcontract.common.req.BatchSignReq;
//import com.pica.cloud.patient.smartcontract.common.resp.ProtocolResp;
//import com.pica.cloud.patient.smartcontract.common.utils.ReturnUtil;
//import groovy.util.logging.Slf4j;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//import org.springframework.util.CollectionUtils;
//import org.springframework.util.StringUtils;
//
//import java.util.ArrayList;
//import java.util.Collections;
//import java.util.List;
//import java.util.Objects;
//
///**
// * @ClassName ProtocolServiceImpl
// * @Description 协议相关业务层
// * @Author Chongwen.jiang
// * @Date 2020/2/20 11:01
// * @ModifyDate 2020/2/20 11:01
// * @Version 1.0
// */
//@Service
//public class ProtocolServiceImpl implements ProtocolService {
//    private Logger logger = LoggerFactory.getLogger(this.getClass());
//    @Autowired
//    private SmartContractClient smartContractClient;
//
//    /**
//     * @Description 批量查询指定类型协议
//     * @Author Chongwen.jiang
//     * @Date 2020/2/20 11:26
//     * @ModifyDate 2020/2/20 11:26
//     * @Params [protocolTypes, appVersion]
//     * @Return java.util.List<com.pica.cloud.patient.smartcontract.common.resp.ProtocolResp>
//     */
//    @Override
//    public List<ProtocolResp> getProtocolNames() {
//        List<Integer> protocolTypes = new ArrayList<>();
//        //  用户协议
//        protocolTypes.add(2);
//        //  隐私协议
//        protocolTypes.add(3);
//        BatchSignReq req = new BatchSignReq();
//        req.setTypes(protocolTypes);
//        PicaResponse picaResponse = smartContractClient.queryProtocol(req);
//        if(Objects.isNull(picaResponse)){
//            throw new PicaWarnException(
//                    PicaResultCode.INTERFACE_INVOKE_EXCEPTION.code(),
//                    PicaResultCode.INTERFACE_INVOKE_EXCEPTION.message());
//        }
//        if(!PicaResultCode.SUCCESS.code().equals(picaResponse.getCode())){
//            throw new PicaWarnException(
//                    picaResponse.getCode(),
//                    picaResponse.getMessage());
//        }
//        List<ProtocolResp> resp = JSON.parseArray(
//                JSON.toJSONString(picaResponse.getData()),
//                ProtocolResp.class);
//        return resp;
//    }
//
//    /**
//     * @Description 首次唤起app签订协议
//     * @Author Chongwen.jiang
//     * @Date 2020/2/20 11:31
//     * @ModifyDate 2020/2/20 11:31
//     * @Params [req]
//     * @Return void
//     */
//    @Override
//    public void firstCallAppSignProtocol(BatchSignReq req, String appVersion) {
//        if(StringUtils.isEmpty(appVersion)) {
//            logger.info("firstCallAppSignProtocol-appVersion is null ");
//            return;
//        }
//
//        PicaResponse resp = smartContractClient.firstCallAppSignProtocol(req);
//        logger.info("firstCallAppSignProtocol-resp:{}", JSON.toJSONString(resp));
//        if(Objects.isNull(resp)){
//            throw new PicaWarnException(
//                    PicaResultCode.INTERFACE_INVOKE_EXCEPTION.code(),
//                    PicaResultCode.INTERFACE_INVOKE_EXCEPTION.message());
//        }
//        if(!PicaResultCode.SUCCESS.code().equals(resp.getCode())){
//            throw new PicaWarnException(
//                    resp.getCode(),
//                    resp.getMessage());
//        }
//    }
//
//
//}
