package com.pica.cloud.account.account.server.mapper;


import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.entity.DoctorEntity;
import com.pica.cloud.account.account.server.entity.PICAPDoctor;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

@Component
public interface DoctorMapper {
    /**
     * 获取医生信息
     *
     * @param mobile 手机号
     * @return
     */
    Doctor getDoctorInfoByMobile(String mobile);


    /**
     * 通过账户信息查询用户id
     *
     * @param acctId
     * @return
     */
    Long selectUserIdByAcctId(Integer acctId);

    /**
     * 通过id获取医生信息
     *
     * @param id
     * @return
     */
    Doctor selectByPrimaryKey(Integer id);


    /**
     * 更新医生信息
     *
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(Doctor record);


    /**
     * 通过账户id更新用户信息
     *
     * @param doctor
     */
    void updateByAcctId(Doctor doctor);

    /**
     * 处理重复的记录(相同手机号多条记录一致)
     */
    int processDoctorRepeatData();

    void updateByMobile(Doctor doctor);

    int deleteByPrimaryKey(Integer id);

    int insert(Doctor record);

    int insertSelective(Doctor record);

    int updateByPrimaryKey(Doctor record);

    /**
     * 绑定微信
     *
     * @param acctId
     * @param unionId
     * @return
     */
    int bindWeChat(@Param("acctId") int acctId, @Param("unionId") String unionId);

    /**
     * 解绑微信
     *
     * @param acctId
     * @return
     */
    int unbindWeChat(@Param("acctId") int acctId);

    PICAPDoctor queryDoctor(long doctorId);

    void updateDeleteByPrimaryKey(@Param("map") HashMap<String, Long> map);


    /**
     * 通过手机号获取用户id
     *
     * @param mobile
     * @return
     */
    //Long selectDoctorIdByMobile(String mobile);

    Integer getAcctIdByDoctorId(long id);

    List<Doctor> getRevertListByDoctorIds(List<Integer> list);

    int updateRevertByIdList(List<Integer> list);

    /**
     * 更新p_doctor表的修改记录
     *
     * @return
     */
    Integer updateDoctorModifyRecord();

    String getUnionIdByDoctorId(@Param("doctorId") Integer doctorId);

}