package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.entity.LoginResult;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.req.OCINRequest;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(description="注册资源")
@RestController
@RequestMapping("/register")
public class RegisterController extends AccountBaseController {

    @Autowired
    private RegisterService registerService;

    @Autowired
    private AccountUtils accountUtils;

    @ApiOperation("PC端，移动端注册接口")
    @PostMapping(value = "")
    public PicaResponse<LoginResult> register(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        accountUtils.checkMobilePhoneAndAuthCode(request.getMobile(),AccountTypeEnum.SYSCODE_TYPE_REGISTER.getCode()+"", request.getAuthCode());
        accountUtils.checkPassword(request.getPassword());
        request.setFlag(AccountTypeEnum.SYSCODE_TYPE_REGISTER.getCode());
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        LoginResult result = registerService.register(request);
        return PicaResponse.toResponse(result);
    }


    @ApiOperation("OCIN项目")
    @PostMapping(value = "/ocin")
    public PicaResponse register(@RequestBody OCINRequest ocinRequest) throws Exception {
        ocinRequest.setFlag(AccountTypeEnum.SYSCODE_TYPE_REGISTER.getCode());
        ocinRequest.setProductType(super.getProductType());
        ocinRequest.setSourceType(super.getSourceType());
        ocinRequest.setLoginIp(super.getIpAddr());
        registerService.ocinRegister(ocinRequest);
        return PicaResponse.toResponse();
    }
}
