package com.pica.cloud.account.account.server.util;

import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import sun.misc.BASE64Decoder;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigInteger;

/**
 * Created on 2019/10/21 13:20
 * author:crs
 * Description:AESUtil
 */
public class AESUtil {

    //密钥 (需要前端和后端保持一致)
    private static final String KEY = "abcdefgabcdefg12";
    //算法
    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";

    public static final String privateKey="MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAJrqPdInBev+ksvBvo+rymL1K0+r5" +
            "a+bq+74tZAHWE2oKVaTSNCbkacXoqPRpzaCqCwyy61zeGExppfZBm8tf6AVAcL+58YF0Fuk+0N4ZaxAi2wx//GqqWQs+Rzt5VPJ+yaulAzs" +
            "Eb0tW9o9Vc9VRxl8k0Fpi5Hj5J/pmLZrIj+FAgMBAAECgYAj+0A8rZ+sfsat2ORgDnDFp1hV+wEwVqIKsW3KdEpIT0S6vR7uhRPBkbXPAwU" +
            "pnhNdoLa6JNXTDWs6XcgmzpSTx32WS3450+h1QNdLL+doiEinWxGijvp+UN7CadoeFBnLml3gGjPpTMeDheialQExwwvVKKe4+0VjO4zPDG" +
            "nrAQJBAM3luGYrweNcFxvVsfQG6cpR/C0DeykyojN0Kbq+3/S+wG1y53Ak1HKz4OHftC4liYNXWy9W1fQ/MSbdVaSka+UCQQDAnJmYwmJ64" +
            "I35T+GmgA0r505BCuYZG9pNyrjdko7n5+DaalRWSXuAwXb2SJbFHvWmVEgZOnVRhPdFgZUGP4shAkAjmG1SrInuhoMwOrdzGqbcZWQVXB60" +
            "tp44CwMT19/b7gZSZaUBTDy2P8bHBeeeerrVTArlmjuO6EXVFDq0JgDJAkBLlCdhHcVu2fZbwdCVeOGyPI0kUJaBe8BpjgaESyHwNbixe8+" +
            "kHCluGHwJn+opZ0CVB7VS0PGAD2DH0VUcooqBAkEAvLBZTnNcM/I2xbV6euw9gpEw7uLkT/94McLQOuZjKPWPHKDQOqa+y+CRPYuxIhQsFK" +
            "mlTze7cR+/4QUANvGAow==";

    /**
     * aes解密
     * @param encrypt   内容
     * @return
     * @throws Exception
    public static String aesDecrypt(String encrypt) {
        try {
            return aesDecrypt(encrypt, KEY);
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
     */

    /**
     * aes加密
     * @param content
     * @return
     * @throws Exception

    public static String aesEncrypt(String content) {
        try {
            return aesEncrypt(content, KEY);
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
     */

    /**
     * 将byte[]转为各种进制的字符串
     * @param bytes byte[]
     * @param radix 可以转换进制的范围，从Character.MIN_RADIX到Character.MAX_RADIX，超出范围后变为10进制
     * @return 转换后的字符串
     */
    public static String binary(byte[] bytes, int radix){
        return new BigInteger(1, bytes).toString(radix);// 这里的1代表正数
    }

    /**
     * base 64 encode
     * @param bytes 待编码的byte[]
     * @return 编码后的base 64 code
     */
    public static String base64Encode(byte[] bytes){
        return Base64.encodeBase64String(bytes);
    }

    /**
     * base 64 decode
     * @param base64Code 待解码的base 64 code
     * @return 解码后的byte[]
     * @throws Exception
     */
    public static byte[] base64Decode(String base64Code) throws Exception{
        return StringUtils.isEmpty(base64Code) ? null : new BASE64Decoder().decodeBuffer(base64Code);
    }

    /**
     * AES加密
     * @param content 待加密的内容
     * @param encryptKey 加密密钥
     * @return 加密后的byte[]
     * @throws Exception
     */
    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(encryptKey.getBytes(), "AES"));

        return cipher.doFinal(content.getBytes("utf-8"));
    }

    /**
     * AES加密为base 64 code
     * @param content 待加密的内容
     * @param encryptKey 加密密钥
     * @return 加密后的base 64 code
     * @throws Exception
     */
    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return base64Encode(aesEncryptToBytes(content, encryptKey));
    }

    /**
     * AES解密
     * @param encryptBytes 待解密的byte[]
     * @param decryptKey 解密密钥
     * @return 解密后的String
     * @throws Exception
     */
    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);

        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(decryptKey.getBytes(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes);
    }


    /**
     * 将base 64 code AES解密
     * @param encryptStr 待解密的base 64 code
     * @param decryptKey 解密密钥
     * @return 解密后的string
     * @throws Exception
     */
    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return StringUtils.isEmpty(encryptStr) ? null : aesDecryptByBytes(base64Decode(encryptStr), decryptKey);
    }


    /**
     * 旧的加解密逻辑
     * @param data
     * @return
     */
    public static String encryptV0(String data) {
        return EncryptCreateUtil.encrypt(data);
    }

    public static String decryptV0(String data) {
        return EncryptCreateUtil.dencrypt(data);
    }

    /**
     * 测试
     */
    public static void main(String[] args) throws Exception {
        String KEY="zJJ$c5md3$yuuhWW";
        System.out.println("-------------加密---------");
        String content = "15607241351";
        System.out.println("加密前：" + content);
        System.out.println("加密密钥和解密密钥：" + KEY);

        System.out.println(
        "-------------解密---------");
        String encrypt = aesEncrypt(content, KEY);
        System.out.println("加密后：" + encrypt);
        String decrypt = aesDecrypt(encrypt, KEY);
        System.out.println("解密后：" + decrypt);


        //请求参数解密处理
//        String key="Vi/4mtanXFW8huqyNi5/XMRWzTkMVFkHCDE53g49ye4AqUsaiKbINdmkFD+g+RyKeS2tEb+6ELukic3GCtZd0wT4iNzK9YVZoMDFQ9JaZwMn0HXSefnSGociozj5hRXHaim3oOuufRKmtJw372rVg4DEVuGLaIpBzdB5wNlaTbY=";
//        String decrypt = RSAUtil.decrypt(key,privateKey);
//        System.out.println(decrypt);
//        String content="lz8KLqk3rWsNLgMxCpuWOb0fQm3s4z6Oej67dYGu5cY=";
//        String result = AESUtil.aesDecrypt(content, decrypt);
//        System.out.println(result);
    }
}
