package com.pica.cloud.account.account.server;


import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication(scanBasePackages = "com.pica.cloud")
@EnableDiscoveryClient
@EnableSwagger2
@EnableFeignClients(basePackages = "com.pica.cloud")
@MapperScan("com.pica.cloud.account.account.server.mapper")
@EnableTransactionManagement
public class App {

    public static void main( String[] args ) {
        SpringApplication.run(App.class, args);
    }

}
