package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.entity.LoginResult;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.common.req.OCINRequest;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.redis.ICacheClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(description = "注册资源")
@RestController
@RequestMapping("/register")
public class RegisterController extends AccountBaseController {


    private final String REPEAT_REGISTER_PREFIX = "repeat-register—";

    @Autowired
    private RegisterService registerService;

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient redisClient;

    @ApiOperation("PC端，移动端注册接口")
    @PostMapping(value = "")
    public PicaResponse<LoginResult> register(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        String mobile = request.getMobile();
        //接口幂等性处理(redis中没有就进行注册逻辑，如果已经存在，就不处理)
        String exist = redisClient.get(REPEAT_REGISTER_PREFIX + mobile);
        if (StringUtils.isBlank(exist)) {
            accountUtils.checkMobilePhoneAndAuthCode(mobile, AccountTypeEnum.SYSCODE_TYPE_REGISTER.getCode() + "", request.getAuthCode());
            accountUtils.checkPassword(request.getPassword());
            redisClient.set(REPEAT_REGISTER_PREFIX + mobile, mobile, 30);
            LoginResult result = null;
            try {
                request.setFlag(AccountTypeEnum.SYSCODE_TYPE_REGISTER.getCode());
                request.setProductType(super.getProductType());
                request.setSourceType(super.getSourceType());
                request.setLoginIp(super.getIpAddr());
                result = registerService.register(request);
            } catch (Exception e) {
                //向上抛出异常，让异常处理框架捕获到
                throw new AccountException(AccountExceptionEnum.PICA_REGISTER_FAIL);
            } finally {
                //如果在注册过程中抛出异常，就删除redis中的注册标记
                redisClient.del(REPEAT_REGISTER_PREFIX + mobile);
            }
            redisClient.del(REPEAT_REGISTER_PREFIX + mobile);
            return PicaResponse.toResponse(result);
        } else {
            return PicaResponse.toResponse(null, AccountExceptionEnum.PICA_ALREADY_REGISTER.getCode(), "正在注册中,请勿重复提交");
        }
    }

    //"sourceType":6 表示长海项目
    @ApiOperation("OCIN项目")
    @PostMapping(value = "/ocin")
    public PicaResponse register(@RequestBody OCINRequest ocinRequest) {
        registerService.ocinRegister(ocinRequest);
        return PicaResponse.toResponse();
    }
}
