package com.pica.cloud.account.account.server.job;

import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.mapper.HospitalMapper;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created on 2019/12/16 17:53
 * author:crs
 * Description:记录doctor修改记录日志
 */
@JobHandler(value = "HospitalLogHandler")
@Component
public class HospitalLogHandler extends IJobHandler {

    @Autowired
    private HospitalMapper hospitalMapper;

    @Override
    public ReturnT<String> execute(String s) throws Exception {
        XxlJobLogger.log("hospitalLogRecord start-----");
        Integer rows = hospitalMapper.updateDoctorModifyRecord();
        XxlJobLogger.log("hospitalLogRecord end-----"+rows);
        return SUCCESS;
    }
}
