package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.common.req.LoginAppletReq;
import com.pica.cloud.account.account.server.entity.AesBean.AesAuthCodeAppletReq;
import com.pica.cloud.account.account.server.entity.AesBean.AesAuthCodeReq;
import com.pica.cloud.account.account.server.entity.*;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.enums.SourceTypeEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.req.AccountReq;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.req.OneClickLoginReq;
import com.pica.cloud.account.account.server.service.*;
import com.pica.cloud.account.account.server.util.*;
import com.pica.cloud.foundation.completeness.client.utils.IntactUtils;
import com.pica.cloud.foundation.encryption.common.constants.EncryptConstants;
import com.pica.cloud.foundation.encryption.util.EncryptUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.entity.PicaWarnException;
import com.pica.cloud.foundation.redis.CacheClient;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.service.starter.interceptor.EnabledLoginValidate;
import com.pica.cloud.foundation.utils.annotation.LoginPermission;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import com.pica.cloud.wechat.applet.client.AppletServiceClient;
import com.pica.cloud.wechat.applet.common.model.AppletModel;
import com.pica.cloud.wechat.applet.common.req.AppletReq;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Date;
import java.util.Map;

@Api(description = "登录资源")
@RestController
public class LoginController extends AccountBaseController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private LoginService loginService;

    @Autowired
    private ICacheClient redisClient;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Autowired
    private TokenService tokenService;

    @Autowired
    private DoctorService doctorService;

    @Autowired
    private CacheClient cacheClient;

    private String cache_prifix = "cache-";

    @Autowired
    private CaptchaService captchaService;

    @Resource
    private AccountController accountController;

    @Autowired
    private AccountService accountService;
    @Autowired
    private IntactUtil intactUtil;
    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    private AppletServiceClient appletServiceClient;

    /**
     * 密码登录接口（app、H5、web）
     *
     * @param authCodeReq
     * @return
     * @throws Exception
     */
    @ApiOperation("密码登录接口")
    @PostMapping("/login")
    public PicaResponse<LoginResult> loginByPassword(@RequestBody AesAuthCodeReq authCodeReq) throws Exception {

        //added by joy begin
        EncryptEntity entity = new EncryptEntity();
        if(StringUtils.isEmpty(authCodeReq.getKey()) && StringUtils.isEmpty(authCodeReq.getContent())){
            //明文时处理
            entity = RSAUtil.getAuthCodeEncrypt(authCodeReq);
            logger.info("AesAuthCodeReq loginByPassword:" + JSONObject.toJSONString(authCodeReq));
            logger.info("AesAuthCodeReq loginByPassword encrypt:" + JSONObject.toJSONString(entity));
            //个别报错数据记流水
            LogLoginAes loginAes = new LogLoginAes();
            loginAes.setChannel(4);
            loginAes.setDeviceToken(authCodeReq.getDevice_token());
            loginAes.setSourceType(null == super.getSourceType() ? 0 : super.getSourceType());
            loginAes.setMobile(authCodeReq.getMobile());
            loginAes.setDeviceInfo(super.getDeviceInfoLow("deviceinfo"));
            loginService.insertLoginAesLog(loginAes);
        }else {
            //执行原逻辑
            entity.setKey(authCodeReq.getKey());
            entity.setContent(authCodeReq.getContent());
        }
        //added by joy end

        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        Integer sourceType = super.getSourceType();
        request.setSourceType(sourceType == null ? 0 : sourceType);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        AccountUtils.checkMobilePhone(request.getMobile());
        AccountUtils.checkPassword(request.getPassword());
        LoginResult login = loginService.login(request);
        if (SourceTypeEnum.SAAS.getCode().equals(sourceType)) {
            login.setDoctorId("");
        } else {
            login.setUserId(null);
        }
        return PicaResponse.toResponse(login);
    }

    /**
     * 一键登录-验证码登录
     *
     * @param authCodeReq
     * @return
     * @throws Exception
     */
    @ApiOperation("PC,App端验证码登录接口，需要完善信息")
    @PostMapping(value = "/login-register")
    public PicaResponse<LoginResult> loginAndRegister(@RequestBody AesAuthCodeReq authCodeReq) throws Exception {
        //added by joy begin
        EncryptEntity entity = new EncryptEntity();
        if(StringUtils.isEmpty(authCodeReq.getKey()) && StringUtils.isEmpty(authCodeReq.getContent())){
            //明文时处理
            entity = RSAUtil.getAuthCodeEncrypt(authCodeReq);
            logger.info("AesAuthCodeReq loginAndRegister:" + JSONObject.toJSONString(authCodeReq));
            logger.info("AesAuthCodeReq loginAndRegister encrypt:" + JSONObject.toJSONString(entity));
            //个别报错数据记流水
            LogLoginAes loginAes = new LogLoginAes();
            loginAes.setChannel(5);
            loginAes.setDeviceToken(authCodeReq.getDevice_token());
            loginAes.setSourceType(null == super.getSourceType() ? 0 : super.getSourceType());
            loginAes.setMobile(authCodeReq.getMobile());
            loginAes.setDeviceInfo(super.getDeviceInfoLow("deviceinfo"));
            loginService.insertLoginAesLog(loginAes);
        }else {
            //执行原逻辑
            entity.setKey(authCodeReq.getKey());
            entity.setContent(authCodeReq.getContent());
        }
        //added by joy end
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        logger.info("login-register:{}",JSONObject.toJSONString(request));
        request.setProductType(super.getProductType());
        Integer sourceType = super.getSourceType();
        request.setSourceType(sourceType == null ? 0 : sourceType);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        LoginResult login = loginService.loginAndRegister(request);
        if (SourceTypeEnum.SAAS.getCode().equals(sourceType)) {
            login.setDoctorId("");
        } else {
            login.setUserId(null);
        }
        return PicaResponse.toResponse(login);
    }

    @ApiOperation("微信登录接口")
    @PostMapping(value = "/login/wechat")
    public PicaResponse<LoginResult> loginByWeChat(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        LoginResult result = loginService.loginByWeChat(request);
        return PicaResponse.toResponse(result);
    }

    @ApiOperation("微信登录第二步接口")
    @PostMapping(value = "/login/wechat/step2")
    public PicaResponse<LoginResult> loginByWeChatStep(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        logger.info("loginByWeChatStep:{}",JSONObject.toJSONString(request));
        LoginResult result = loginService.loginByWeChatStep(request);
        return PicaResponse.toResponse(result);
    }

    /**
     * 绑定微信接口
     *
     * @param entity
     * @return
     * @throws Exception
     */
    @ApiOperation("绑定微信接口")
    @PostMapping("/login/wechat/bind")
    public PicaResponse bindWeChat(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        logger.info("bindWeChat:{}",JSONObject.toJSONString(request));
        request.setUserTokenTourist(super.getUserTokenTourist());
        Long result = cacheClient.setnx(cache_prifix + request.getWeChatCode(), request.getWeChatCode());
        if (result == 1) {
            try {
                cacheClient.expire(cache_prifix + request.getWeChatCode(), 60);
                long doctorId = super.getDoctorIdByToken();
                logger.info("bindWeChat doctorId:{}",doctorId);
//                String nickname = loginService.bindWeChat(doctorId, request);
                Map<String,String> rtnMap = loginService.bindWeChatMap(doctorId, request);

//                Map<String, String> map = new HashMap();
//                map.put("nickname", rtnMap.get("nickname"));
                //成功以后释放锁
                cacheClient.del(cache_prifix + request.getWeChatCode());
                return PicaResponse.toResponse(rtnMap);
            } catch (Exception e) {
                cacheClient.del(cache_prifix + request.getWeChatCode());
                logger.error("bindWeChat-" + e.getMessage(), e);
                if(e instanceof PicaException) {
                    throw new PicaException(((PicaException) e).getCode(), ((PicaException) e).getMsg());
                }
                throw new PicaWarnException(AccountExceptionEnum.PICA_BIND_WECHAT_FAIL.getCode(), AccountExceptionEnum.PICA_BIND_WECHAT_FAIL.getMessage());
            }
        } else {
            return PicaResponse.toResponse(null, AccountExceptionEnum.PICA_WECHAT_UNBIND_CURRENT.getCode(),
                    AccountExceptionEnum.PICA_WECHAT_UNBIND_CURRENT.getMessage());
        }
    }

    @ApiOperation("微信解除绑定接口")
    @PutMapping("/login/wechat/unbind")
    public PicaResponse unbindWeChat() {
        long doctorId = super.getDoctorIdByToken();
        loginService.unbindWeChat(doctorId);
        return PicaResponse.toResponse();
    }

    /**
     * 退出登录接口，返回一个随机token
     * 1)登录状态调用，2)清除token
     *
     * @return
     */
    @ApiOperation(value = "退出登录接口")
    @GetMapping("/logout")
    public PicaResponse<String> loginOut() {
        String token = super.getToken();
        if (StringUtils.isNotEmpty(token)) {
            Long doctorId = super.getDoctorIdByToken();
            Doctor doctorInfo = doctorService.getDoctorInfo(doctorId.intValue());
            Map<String, Object> headersMap = super.getHeaders();
            if (StringUtil.isNotNull(doctorInfo)) {
                Integer acctId = doctorInfo.getAcctId();
                redisClient.deleteToken(token);
                String newToken = tokenService.getToken(headersMap);
                LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, super.getProductType(), super.getSourceType(),
                        AccountTypeEnum.LOGIN_OUT.getCode(), super.getIpAddr(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(), AccountTypeEnum.LOG_TYPE_LOGIN.getCode(),
                        newToken,0,super.getUserTokenTourist());
                picaLogUtils.info(entity);
                return PicaResponse.toResponse(newToken);
            } else {
                String newToken = tokenService.getToken(headersMap);
                return PicaResponse.toResponse(newToken);
            }
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_LOGIN_AGAIN);
        }
    }

    @ApiOperation(value = "web登录获取用户信息")
    @GetMapping("/login/web")
    public PicaResponse<LoginResultWeb> getLoginResult() {
        LoginResultWeb resultWeb = new LoginResultWeb();
        long doctorId = super.getDoctorIdByToken();
        if (doctorId <= 0) {
            resultWeb.setIsExist(2);
            return PicaResponse.toResponse(resultWeb);
        }

        PICAPDoctor doctor = loginService.queryDoctor(doctorId);
        resultWeb.setPicapDoctor(doctor);
        if (doctor.getStatus() != null) {
            resultWeb.setCertifyDoc(doctor.getStatus().intValue());
        }
        return PicaResponse.toResponse(resultWeb);
    }

    @ApiOperation(value = "统一校验(传空则不会校验)")
    @PostMapping("/unifiedVerification")
    public PicaResponse unifiedVerification(@RequestBody AesAuthCodeReq req) throws Exception{

        //added by joy begin
        EncryptEntity entity = new EncryptEntity();
        if(StringUtils.isEmpty(req.getKey()) && StringUtils.isEmpty(req.getContent())){
            //明文时处理
            entity = RSAUtil.getAuthCodeEncrypt(req);
            logger.info("AesAuthCodeReq unifiedVerification:" + JSONObject.toJSONString(req));
            logger.info("AesAuthCodeReq unifiedVerification encrypt:" + JSONObject.toJSONString(entity));
            //个别报错数据记流水
            LogLoginAes loginAes = new LogLoginAes();
            loginAes.setChannel(2);
            loginAes.setDeviceToken(req.getDevice_token());
            loginAes.setSourceType(null == super.getSourceType() ? 0 : super.getSourceType());
            loginAes.setMobile(req.getMobile());
            loginAes.setDeviceInfo(super.getDeviceInfoLow("deviceinfo"));
            loginService.insertLoginAesLog(loginAes);
        }else {
            //执行原逻辑
            entity.setKey(req.getKey());
            entity.setContent(req.getContent());
        }
        //added by joy end

        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setSourceType(super.getSourceType());
        logger.info("unifiedVerification:{}",JSONObject.toJSONString(request));
        loginService.preLoginValidate(request);
        return PicaResponse.toResponse();
    }

    @ApiOperation(value = "苹果授权登录")
    @PostMapping("/login/apple")
    public PicaResponse appleAuth(@RequestBody EncryptEntity entity) throws Exception{
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        logger.info("appleAuth:{}", JSONObject.toJSONString(request));
        return PicaResponse.toResponse(loginService.loginByApple(request));
    }

    @ApiOperation(value = "苹果登录绑定手机号")
    @PostMapping("/login/apple/step2")
    public PicaResponse appleAuthBind(@RequestBody EncryptEntity entity) throws Exception{
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        logger.info("appleAuthBind:{}",JSONObject.toJSONString(request));
        return PicaResponse.toResponse(loginService.loginByAppleStep(request));
    }

    @ApiOperation(value = "苹果登录-跳过绑定-静默注册")
    @PostMapping("/login/apple/skip/register")
    public PicaResponse appleSkipRegister(@RequestBody EncryptEntity entity) throws Exception{
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        logger.info("appleSkipRegister:{}",JSONObject.toJSONString(request));
        return PicaResponse.toResponse(loginService.appleSkipRegister(request));
    }


    @ApiOperation(value = "app端手机号码一键登录")
    @PostMapping("/login/one-click")
    public PicaResponse<LoginResult> oneClickLogin(@RequestBody AesAuthCodeReq aesReq) throws Exception {

        //added by joy begin
        EncryptEntity entity = new EncryptEntity();
        if(StringUtils.isEmpty(aesReq.getKey()) && StringUtils.isEmpty(aesReq.getContent())){
            //明文时处理
            entity = RSAUtil.getOneClickEncrypt(aesReq);
            logger.info("AesAuthCodeReq oneClickLogin:" + JSONObject.toJSONString(aesReq));
            logger.info("AesAuthCodeReq oneClickLogin encrypt:" + JSONObject.toJSONString(entity));
            //个别报错数据记流水
            LogLoginAes loginAes = new LogLoginAes();
            loginAes.setChannel(3);
            loginAes.setDeviceToken(aesReq.getDevice_token());
            loginAes.setSourceType(null == super.getSourceType() ? 0 : super.getSourceType());
            loginAes.setOneToken(aesReq.getToken());
            loginAes.setMobile(aesReq.getMobile());
            loginAes.setDeviceInfo(super.getDeviceInfoLow("deviceinfo"));
            loginService.insertLoginAesLog(loginAes);
        }else {
            //执行原逻辑
            entity.setKey(aesReq.getKey());
            entity.setContent(aesReq.getContent());
        }
        //added by joy end

        OneClickLoginReq req = CryptoUtil.decrypt(entity, OneClickLoginReq.class);
        req.setProductType(super.getProductType());
        req.setSourceType(super.getSourceType());
        req.setLoginIp(super.getIpAddr());
        req.setUserTokenTourist(super.getUserTokenTourist());
        logger.info("one-click req:{}",JSONObject.toJSONString(req));
        LoginResult oneClickLoginResultVo = loginService.oneClickLogin(req);
        return PicaResponse.toResponse(oneClickLoginResultVo);
    }

    @ApiOperation(value = "web登录-图形码")
    @PostMapping("/web/captchaPwd")
    public PicaResponse<LoginResult> webCaptchaPwd(@RequestBody EncryptEntity entity,
                                                   HttpServletRequest req) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        logger.info("webCaptchaPwd:{}", JSONObject.toJSONString(request));
        String captchaToken = request.getCaptchaToken();
        String captchaAnswer = request.getCaptchaAnswer();
        //校验图形验证码
        if (!captchaService.acknowledge(captchaToken, captchaAnswer)) {
            return PicaResponse.toResponse(null, PicaResultCode.PARAM_IS_INVALID.code(), "图形验证码错误");
        }

        //原登录逻辑
        request.setProductType(super.getProductType());
        Integer sourceType = super.getSourceType();
        request.setSourceType(sourceType == null ? 0 : sourceType);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        AccountUtils.checkMobilePhone(request.getMobile());
        AccountUtils.checkPassword(request.getPassword());
        LoginResult login = loginService.login(request);
        if (SourceTypeEnum.SAAS.getCode().equals(sourceType)) {
            login.setDoctorId("");
        } else {
            login.setUserId(null);
        }
        return PicaResponse.toResponse(login);
    }

    @ApiOperation(value = "二维码扫码登录")
    @PostMapping("/login/QRCode")
    @LoginPermission
    public PicaResponse<String> loginQRCode() {
        BaseRequest request = new BaseRequest();
        request.setProductType(1);
        request.setSourceType(3);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        request.setMobile(this.fetchPicaUser().getMobile());
        LoginResult login = loginService.loginQRCode(request);

        return PicaResponse.toResponse(login.getToken());
    }

    @ApiOperation(value = "切换登录")
    @PostMapping("/login/switch")
    @EnabledLoginValidate
    public PicaResponse<String> loginSwitch(@RequestBody EncryptEntity entity) throws Exception {
        Map<String, Object> req = CryptoUtil.decrypt(entity, Map.class);
        loginService.loginSwitch(super.getAccountUser(), super.getRedisClient().getToken(String.valueOf(req.get("token")), AccountUser.class));
        return PicaResponse.toResponse();
    }


    /**
     * saas机构管理平台密码登录接口
     * 
     * @author wenlei.liao
     * @date 2022/3/1 18:45
     * @param
     * @return 
    */
    @ApiOperation("saas机构管理平台密码登录接口")
    @PostMapping("/saasLogin")
    public PicaResponse<SaasLoginResult> saasLogin(@RequestBody SaasLoginReq authCodeReq) throws Exception {
        EncryptEntity entity = new EncryptEntity();
        entity.setKey(authCodeReq.getKey());
        entity.setContent(authCodeReq.getContent());
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        Integer sourceType = super.getSourceType();
        request.setSourceType(sourceType == null ? 0 : sourceType);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        AccountUtils.checkMobilePhone(request.getMobile());
        AccountUtils.checkPassword(request.getPassword());
        SaasLoginResult login = loginService.saasLogin(request);
        return PicaResponse.toResponse(login);
    }


    @ApiOperation("saas机构管理平台验证码登录接口")
    @PostMapping("/saasLoginByAuthCode")
    public PicaResponse<SaasLoginResult> saasLoginByAuthCode(@RequestBody SaasLoginReq authCodeReq) throws Exception {
        EncryptEntity entity = new EncryptEntity();
        entity.setKey(authCodeReq.getKey());
        entity.setContent(authCodeReq.getContent());
        logger.info("saasLoginByAuthCode 验证码登陆接口参数：{}", JSON.toJSONString(entity));
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        logger.info("saasLoginByAuthCode 解密之后的数据request：{}", JSON.toJSONString(request));
        request.setProductType(super.getProductType());
        Integer sourceType = super.getSourceType();
        request.setSourceType(sourceType == null ? 0 : sourceType);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        AccountUtils.checkMobilePhone(request.getMobile());

        try {
            //校验验证码
            accountController.checkMobilePhone(request.getMobile());
            AccountReq accountReq = new AccountReq();
            accountReq.setMobilePhone(request.getMobile());
            accountReq.setFlag("0");
            accountReq.setAuthCode(request.getAuthCode());
            accountController.checkAuthCode(accountReq);
        } catch (PicaException e) {
            logger.info("saasLoginByAuthCode 短信验证失败");
            return PicaResponse.toResponse(null, e.getCode(), e.getMsg());
        }catch (Exception e) {
            logger.info("saasLoginByAuthCode 短信验证失败");
            return PicaResponse.toResponse(null,PicaResultCode.DATA_EXCEPTION.code(), "短信校验异常");
        }

        SaasLoginResult login = loginService.saasLoginByAuthCode(request);
        return PicaResponse.toResponse(login);
    }


    @ApiOperation("云鹊医助手小程序授权登录")
    @PostMapping("/login/applet")
    public PicaResponse<String> loginApplet(@RequestBody LoginAppletReq req) {
        accountController.checkMobilePhone(req.getMobilePhone());
        logger.info("login applet :{}", JSONObject.toJSONString(req));
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo, "login/applet", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1, "req:" + JSON.toJSONString(req));
        Account account = accountService.getByMobilePhone(req.getMobilePhone());  //获取账号信息
        if (account == null) {
            intactUtil.sendIntact(batchNo, "login/applet", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3, "未注册，请验证码登录");
            return PicaResponse.toResponse(null, PicaResultCode.RESULE_DATA_NONE.code(), "本APP采用实名注册制\n如需注册请联系客服" + redisClient.get( "mobile_400_1"));
        }

        //更新最后登录时间
        Account update = new Account();
        update.setId(account.getId());
        update.setLastLoginTime(new Date());
        update.setModifyId(account.getId());
        update.setModifyTime(new Date());
        accountService.updateAccountById(update);

        //登录成功，清除旧token，生成新token
        Account account1 = new Account();
        account1.setId(account.getId());
        account1.setAcctId(account.getAcctId());
        account1.setCreatTime(new Date());
        account1.setMobilePhone(req.getMobilePhone());
        account1.setRegisterSource(4);
        String newToken = tokenUtils.generateToken(account1);

        int expiredSeconds = 24 * 60 * 60 * 30;
        cacheClient.set("token-doctor-unionid-"+req.getUnionid(),newToken,expiredSeconds);
        cacheClient.set("token-unionid-"+newToken,req.getUnionid(),expiredSeconds);
        cacheClient.set("token-openid-"+newToken,req.getOpenid(),expiredSeconds);

        intactUtil.sendIntact(batchNo, "login/applet", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3, "req:" + JSON.toJSONString(req));
        return PicaResponse.toResponse(newToken);
    }

    @ApiOperation("云鹊医助手小程序授权登录")
    @PostMapping("/login/applet/authCode")
    public PicaResponse<LoginResult> loginAppletAuthCode(@RequestBody AesAuthCodeAppletReq authCodeReq) {
        AppletModel appletModel = appletServiceClient.code2Session(authCodeReq.getCode(),authCodeReq.getType()).getData();
        if (StringUtil.isNull(appletModel) || StringUtil.isNull(appletModel.getUnionId())) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(),"小程序code解密失败");
        }
        BaseRequest request = new BaseRequest();
        request.setMobile(authCodeReq.getMobile());
        request.setAuthCode(authCodeReq.getAuthCode());
        logger.info("login-register:{}",JSONObject.toJSONString(request));
        request.setProductType(1);
        request.setSourceType(4);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        LoginResult login = loginService.loginAndRegister(request);
        if (StringUtil.isNotNull(login)) {
            int expiredSeconds = 24 * 60 * 60 * 30;
            cacheClient.set("token-doctor-unionid-"+appletModel.getUnionId(),login.getToken(),expiredSeconds);
            cacheClient.set("token-unionid-"+login.getToken(),appletModel.getUnionId(),expiredSeconds);
            cacheClient.set("token-openid-"+login.getToken(),appletModel.getOpenId(),expiredSeconds);

            /** 绑定医生和unionid关系 */
            appletServiceClient.insertAppletDoctor(appletModel.getUnionId(), EncryptUtils.encryptContent(login.getUserId().toString(), EncryptConstants.ENCRYPT_TYPE_DOCTOR_ID));

        }
        return PicaResponse.toResponse(login);
    }


    /**
     * 退出登录接口，返回一个随机token
     *
     * @return
     */
    @ApiOperation(value = "云鹊医助手小程序退出登录接口")
    @GetMapping("/logout/applet")
    public PicaResponse loginOutApplet() {
        String token = super.getToken();
        if (StringUtils.isNotEmpty(token)) {
            try {
                Long doctorId = super.getDoctorIdByToken();
                Doctor doctorInfo = doctorService.getDoctorInfo(doctorId.intValue());
                if (StringUtil.isNotNull(doctorInfo)) {
                    Integer acctId = doctorInfo.getAcctId();

                    LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, 1, 4,
                            AccountTypeEnum.LOGIN_OUT.getCode(), super.getIpAddr(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(), AccountTypeEnum.LOG_TYPE_LOGIN.getCode(),
                            "",0,super.getUserTokenTourist());
                    picaLogUtils.info(entity);
                }
            } catch (Exception e) {

            }

            String unionid = redisClient.get("token-unionid-" +token);
            redisClient.del("token-unionid-" +token);
            redisClient.del("token-openid-" +token);
            redisClient.del("token-doctor-unionid-" +unionid);
            return PicaResponse.toResponse();
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_LOGIN_AGAIN);
        }
    }
}
