package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.common.req.HongShanRequest;
import com.pica.cloud.account.account.common.req.OCINRequest;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.entity.LoginResult;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(description = "注册资源")
@RestController
@RequestMapping("/register")
public class RegisterController extends AccountBaseController {

    @Autowired
    private RegisterService registerService;

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    private ICacheClient redisClient;

    private Logger logger = LoggerFactory.getLogger(RegisterController.class);

    @ApiOperation("PC端，移动端注册接口")
    @PostMapping(value = "")
    public PicaResponse<LoginResult> register(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        logger.info("register:{}", JSONObject.toJSONString(request));
        String mobile = request.getMobile();
        //接口幂等性处理(redis中没有就进行注册逻辑，如果已经存在，就不处理)
        String authCode = request.getAuthCode();
        String flag = AccountTypeEnum.SYSCODE_TYPE_REGISTER.getCode() + "";
        //验证码验证的原子操作
        accountUtils.checkRegisterMobilePhoneAndAuthCode(mobile, flag, authCode);
        accountUtils.checkPassword(request.getPassword());
        LoginResult result = null;
        request.setFlag(AccountTypeEnum.SYSCODE_TYPE_REGISTER.getCode());
        request.setProductType(super.getProductType());
        Integer sourceType = super.getSourceType();
        request.setSourceType(sourceType);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        result = registerService.register(request);
        if (sourceType==3){
            result.setDoctorId("");
        }
        return PicaResponse.toResponse(result);
    }

    //"sourceType":6 表示长海项目
    @ApiOperation("OCIN项目")
    @PostMapping(value = "/ocin")
    public PicaResponse register(@RequestBody OCINRequest ocinRequest) {
        registerService.ocinRegister(ocinRequest);
        return PicaResponse.toResponse();
    }

    @ApiOperation("红杉项目")
    @PostMapping(value = "/hongshan")
    public PicaResponse<LoginResult> registerHongShan(@RequestBody HongShanRequest hongShanRequest) {
        return PicaResponse.toResponse(registerService.hongShanRegister(hongShanRequest));
    }
}
