package com.pica.cloud.account.account.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.pica.cloud.account.account.common.req.PatFamilyRecordReq;
import com.pica.cloud.account.account.server.entity.AccountPatFamilyRecord;
import com.pica.cloud.account.account.server.mapper.AccountPatFamilyRecordMapper;
import com.pica.cloud.account.account.server.service.AccountPatFamilyRecordService;
import com.pica.cloud.account.account.server.service.CaptchaService;
import com.pica.cloud.account.account.server.util.MemcachedClientWrapper;
import com.pica.cloud.account.account.server.util.captcha.CaptchaGenerator;
import com.pica.cloud.account.account.server.util.captcha.CaptchaToken;
import com.pica.cloud.foundation.utils.constants.CommonConstants;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.UUID;


@Component
public class AccountPatFamilyRecordServiceImpl implements AccountPatFamilyRecordService {

    private static Logger logger = LoggerFactory.getLogger(AccountPatFamilyRecordServiceImpl.class);

    @Autowired
    private AccountPatFamilyRecordMapper accountPatFamilyRecordMapper;

    @Override
    public void saveRecord(PatFamilyRecordReq recordReq) {
        logger.info("AccountPatFamilyRecordServiceImpl/saveRecord : " + JSON.toJSONString(recordReq));
        if (recordReq != null) {
            AccountPatFamilyRecord record = new AccountPatFamilyRecord();
            BeanUtils.copyProperties(recordReq, record);
            Date now = new Date();
            record.setDeleteFlag(1);
            record.setCreatedTime(now);
            record.setModifiedTime(now);
            accountPatFamilyRecordMapper.insert(record);
        }
    }

}
