package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.AccountInfoService;
import com.pica.cloud.account.account.server.service.DoctorService;
import com.pica.cloud.account.account.server.service.ModifyMobileService;
import com.pica.cloud.account.account.server.service.impl.AccountServiceImpl;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(description = "修改手机号资源")
@RestController
public class ModifyMobileController extends AccountBaseController {

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    private ModifyMobileService modifyMobileService;

    @Autowired
    private DoctorService doctorService;

    @Autowired
    private AccountServiceImpl accountService;


    @ApiOperation("修改手机号")
    @PostMapping("/mobile/modify")
    public PicaResponse modifyMobile(@RequestBody EncryptEntity entity) throws Exception {
        Long doctorId = super.getDoctorIdByToken();
        Doctor doctorInfo = doctorService.getDoctorInfo(doctorId.intValue());
        //旧的手机号
        String mobilePhone = doctorInfo.getMobilePhone();
        Integer acctId = modifyMobileService.getAcctIdByMobile(mobilePhone);
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        //新的手机号
        String mobile = request.getMobile();
        accountUtils.checkMobilePhoneAndAuthCode(mobile, AccountTypeEnum.SYSCODE_TYPE_MODIFY_MOBILE.getCode() + "", request.getAuthCode());
        //判断当前手机号是否已经注册过
        AccountInfoEntity accountInfoEntity = accountService.getAccountByMobilePhone(mobile);
        if (accountInfoEntity == null) {
            modifyMobileService.recodeMobileModify(acctId,mobilePhone,mobile);
            modifyMobileService.modify(acctId, mobile);
            return PicaResponse.toResponse();
        } else {
            return PicaResponse.toResponse(null,AccountExceptionEnum.PICA_ALREADY_REGISTER.getCode(),AccountExceptionEnum.PICA_ALREADY_REGISTER.getMessage());
        }
    }
}
