package com.pica.cloud.account.account.server.util;

import com.pica.cloud.foundation.encryption.common.constants.EncryptConstants;
import com.pica.cloud.foundation.encryption.util.EncryptUtils;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import sun.misc.BASE64Decoder;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/**
 * Created on 2019/10/21 13:20
 * author:crs
 * Description:AESUtil
 */
public class AESUtil {

    //密钥 (需要前端和后端保持一致)
    private static final String KEY = "abcdefgabcdefg12";
    //算法
    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";

    public static final String privateKey = "MIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBAKdXMOUboMkHBOyfuMWuIo6bOp+b53i/LoO0qox+sQ+DqFTdt9tH1dF/CoAWtLj5CjDJum7JYJrsMXIqXQnIRr8ZKt+NtdKlqUUeGZYfTPSEIXWb9S+U8DQFqJgXL25xcX1SHxFoeRkZWZX5FtUhKTimOVl1FwrkRDmFyIEUa2AbAgMBAAECgYEAlEZHxtoiL74OePRVrqNLb3zQBxkHkxAj0QPGktK3ZP3Nq9UB0kTmisi8rx5vZ+8TPoOgtAWvmdZrQbOT2NUjCUYKkGS+Wi1fXpP0Az2UJwDIQK4aQTZtNbM04f3Rmi5i24eASmSdl1svjHEv0YS6IC6sR1cbElZs94uDFshUeqECQQDTrmZda8fo6ZNsHVYWcjTwr8JKTIgjaD/hPi0JP6hhL0GVEAVwb2rsfJf5o2TR5RsNT8ANUYgFPRaAymLLe+5zAkEAymA9V55K6IJhnSp7HmWfGVmxvTrwZFJIzPv7DLi/RAS3yFPfTpyJGLirAnBQfKO/vwjxhAuwD21aDYHMTrj1uQJBAJdAikw+cz1tiLU70QOA32sLaxyDytLh7qMXNj7hiYLHrWjBZeGM+y23aTArHCMOPWIpleTuWO7FU4r7EdSr3RkCQQCliu4CwyhRY33H210U81memgFLYnAMEEce7qxgrqs+T4Gqa/lJy8BVqZGxkAA2xJfwA7fUJN9i7zdvvxJJ/wB5AkA+OKfnTXTp8qF4lZiVMrGl3d5sgg87q1DhC5XruviH6a3u6JOLlRNQy2+TGxzWMYaJ1RwEfygqBYOgyvoqNR3Q";

    private static final String charset = "UTF-8";
    /**
     * aes解密
     * @param encrypt   内容
     * @return
     * @throws Exception
    public static String aesDecrypt(String encrypt) {
        try {
            return aesDecrypt(encrypt, KEY);
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
     */

    /**
     * aes加密
     * @param content
     * @return
     * @throws Exception

    public static String aesEncrypt(String content) {
        try {
            return aesEncrypt(content, KEY);
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
     */

    /**
     * 将byte[]转为各种进制的字符串
     * @param bytes byte[]
     * @param radix 可以转换进制的范围，从Character.MIN_RADIX到Character.MAX_RADIX，超出范围后变为10进制
     * @return 转换后的字符串
     */
    public static String binary(byte[] bytes, int radix){
        return new BigInteger(1, bytes).toString(radix);// 这里的1代表正数
    }

    /**
     * base 64 encode
     * @param bytes 待编码的byte[]
     * @return 编码后的base 64 code
     */
    public static String base64Encode(byte[] bytes){
        return Base64.encodeBase64String(bytes);
    }

    /**
     * base 64 decode
     * @param base64Code 待解码的base 64 code
     * @return 解码后的byte[]
     * @throws Exception
     */
    public static byte[] base64Decode(String base64Code) throws Exception{
        return StringUtils.isEmpty(base64Code) ? null : new BASE64Decoder().decodeBuffer(base64Code);
    }

    /**
     * AES加密
     * @param content 待加密的内容
     * @param encryptKey 加密密钥
     * @return 加密后的byte[]
     * @throws Exception
     */
    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(encryptKey.getBytes(), "AES"));

        return cipher.doFinal(content.getBytes("utf-8"));
    }

    /**
     * AES加密为base 64 code
     * @param content 待加密的内容
     * @param encryptKey 加密密钥
     * @return 加密后的base 64 code
     * @throws Exception
     */
    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return base64Encode(aesEncryptToBytes(content, encryptKey));
    }

    /**
     * AES解密
     * @param encryptBytes 待解密的byte[]
     * @param decryptKey 解密密钥
     * @return 解密后的String
     * @throws Exception
     */
    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);

        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(decryptKey.getBytes(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes);
    }


    /**
     * 将base 64 code AES解密
     * @param encryptStr 待解密的base 64 code
     * @param decryptKey 解密密钥
     * @return 解密后的string
     * @throws Exception
     */
    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return StringUtils.isEmpty(encryptStr) ? null : aesDecryptByBytes(base64Decode(encryptStr), decryptKey);
    }


    /**
     * 旧的加解密逻辑
     * @param data
     * @return
     */
    public static String encryptV0(String data) {
        return EncryptCreateUtil.encrypt(data);
    }

    public static String decryptV0(String data) {
        return EncryptCreateUtil.dencrypt(data);
    }

    public static String decrypt(String sSrc, String sKey, String siv) throws Exception {
        try {
            if (sSrc == null || sSrc.length() == 0) {
                return null;
            }
            if (sKey == null) {
                throw new Exception("decrypt key is null");
            }
            if (sKey.length() != 16) {
                throw new Exception("decrypt key length error");
            }
            byte[] Decrypt = ByteFormat.hexToBytes(sSrc);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec skeySpec = new SecretKeySpec(sKey.getBytes(charset), "AES");
            IvParameterSpec iv = new IvParameterSpec(siv.getBytes(charset));//new IvParameterSpec(getIV());
            cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);//使用解密模式初始化 密
            return new String(cipher.doFinal(Decrypt), charset);
        } catch (Exception ex) {
            throw new Exception("decrypt errot", ex);
        }
    }

    /**
     * 测试
     */
    public static void main(String[] args) throws Exception {



        String KEY="zJJ$c5md3$yuuhWW";
        System.out.println("-------------加密---------");
        String content = "18709744120";



        System.out.println("加密前：" + content);
        System.out.println("加密密钥和解密密钥：" + KEY);

        System.out.println("-------------解密---------");
        String encrypt = aesEncrypt(content, KEY);
        System.out.println("加密后：" + encrypt);
        String decrypt = aesDecrypt(encrypt, KEY);
        System.out.println("解密后：" + decrypt);



//        List<String> list = new ArrayList<>();
//
//        String str="13330782565,13638247234,15208346780,13665702440,13171898394,13526001352,15637729989,18282702080,17839157550,13733479385,13873347938,18192022131,17868481983,13389208740,15130643581,18743289267,15025550691,18706903023,15153299810,13400213017,13400213014,13809393727,15082898689,15181524146,13067777147,15936327251,13982581989,13055116890,13183128853,13526235120,13620258773,13470126432,15379993781,15612968111,15930496256,13504498834,13328506266,13405379887,18636815186,18638124991,18997577751,18742986968,13737844850,15249387846,13890801202,18294832224,15329652816,13453947981,17393142302,18219810087,15031950900,18670808468,18670508468,18670508568,15566394123,18719884109,13789221826,13939497532,13939925847,13791830377,18919411543,18893835167,18194329526,13207866808,13082126549,15802548543,15879451129,15390381641,13132431383,18279911958,13827920609,15209825253,15509825253,18184482231,13325225232,15908034636,15352111767,18709744120,15807269519,19971489100,13721734937,13765575183,15329652819,13883396206,18085581329,15090694439,15090694436,13782477033,13207995156,13630682016,15607241351,13830780802";
//        String[] arr = str.split(",");
//        for (int i = 0; i < arr.length; i++) {
//        String KEY="zJJ$c5md3$yuuhWW";
//        System.out.println("-------------加密---------");
//        String content = arr[i];
//        System.out.println("加密前：" + content);
//        System.out.println("加密密钥和解密密钥：" + KEY);
//
//        System.out.println("-------------解密---------");
//        String encrypt = aesEncrypt(content, KEY);
//        System.out.println("加密后：" + encrypt);
//        String decrypt = aesDecrypt(encrypt, KEY);
//        System.out.println("解密后：" + decrypt);
//            list.add(encrypt);
//        }
//
//        for (int i = 0; i < list.size(); i++) {
//            System.out.println(list.get(i));
//        }



//          请求参数解密处理
//        String key="HSBPIMChYBYHKMb/wmq0dYIKnUU5UvlzeWrWkmxWUJ0RI2cgEf9jcISPHfLsJurCjj5xwTz6KjPnm0Z+ylaiVDpiLT55vKWHC0HnPqVePSR6Sn6cdaESDCMMGbNdJb+crnjvfTo0v4zQwqvjUJBDR9KRc5C3Dr07dITbPQbJXJk=";
//        String decrypt = RSAUtil.decrypt(key,privateKey);
//        System.out.println(decrypt);
//        String content="L/05P603DA9u/as3uHbzsF+LqYhfxJonT80u0oH0YobLCta/wR1xEH//NccyJlQ";
//        String result = AESUtil.aesDecrypt(content, decrypt);
//        System.out.println(result);


//        ArrayList<String> list = new ArrayList<>();
//        int[] a = {99857217,99857231,99884890,99885124,99887349,99888816,99888820,99888821,99888822,99888830,99888831,99888837,99888842,99888847,99888851,99888855,99888860,99888867,99888876,99888879,99888884,99888896,99888897,99888900,99888901,99888923,99888930,99888943,99888983,99889000,99889032,99889043,99889046,99889104,99889142,99889158,99889165,99889177,99889184,99889218,99889230,99889236,99889250,99889304,99889380,99889401,99889426,99889435,99889508,99889510,99889538,99889719,99889723,99889731,99889922,99889931,99890029,99890043,99890137,99890152,99890157,99890163,99890237,99890461,99890473,99890485,99890495,99890656,99890658,99890662,99890663,99890670,99890774,99891395,99891410,99891424,99891432,99891439,99891480,99891517};
//        for (int i = 0; i <a .length ; i++) {
//            Integer id = a[i];
//            list.add(EncryptUtils.encryptContent(id.toString(), EncryptConstants.ENCRYPT_TYPE_ID));
//        }
//        System.out.println(list.toArray());

    }
}
