// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Max;

/**
 * @Author qinwh
 * @Date 2022/3/1 20:27
 */
@Data
@ApiModel
public class HospitalRoleDetailReq {

    @ApiModelProperty("角色id")
    private Long id;

    @ApiModelProperty("角色名称")
    @NotBlank(message = "角色名称不能为空")
    @Max(value = 16, message = "角色名称长度≤16字符")
    private String name;

    @ApiModelProperty("角色描述")
    @Max(value = 100, message = "描述长度≤100字符")
    private String remark;

}
