package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.service.DoctorService;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.AccountUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.HashMap;

/**
 * Created on 2019/9/11 11:02
 * author:crs
 * Description:医生相关Service
 */
@Service
public class DoctorServiceImpl implements DoctorService {

    @Autowired
    private DoctorMapper doctorMapper;

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Override
    public Doctor getDoctorInfo(Integer id) {
        return doctorMapper.selectByPrimaryKey(id);
    }

    @Transactional
    @Override
    public void modifyDoctorInfo(Doctor doctor,Long doctorId) {
        Integer id = doctor.getId();
        if (id == null) {
            throw new AccountException(AccountExceptionEnum.PICA_PARAMS_ERROR);
        }
        Doctor entity = doctorMapper.selectByPrimaryKey(id);
        if (entity == null) {
            throw new AccountException(AccountExceptionEnum.PICA_NOT_EXIST);
        }
        String mobilePhone = doctor.getMobilePhone();
        if (!StringUtils.isBlank(mobilePhone)) {
            AccountUtils.checkMobilePhone(doctor.getMobilePhone());
        }
        doctor.setMobilePhone(AESUtil.encryptV0(mobilePhone));
        doctor.setModifyTime(new Date());
        doctorMapper.updateByPrimaryKeySelective(doctor);
        Integer acctId = entity.getAcctId();
        AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
        accountInfoEntity.setMobilePhone(AESUtil.encryptV0(mobilePhone));
        accountInfoEntity.setId(acctId);
        accountInfoEntity.setModifiedId(doctorId.intValue());
        accountInfoEntity.setModifiedTime(new Date());
        accountInfoDetailMapper.updateByPrimaryKeySelective(accountInfoEntity);
    }

    @Transactional
    @Override
    public void deleteDoctorInfo(Integer id,Long modifyId) {
        //p_doctor表修改记录状态
        Doctor doctor = doctorMapper.selectByPrimaryKey(id);
        if (doctor != null) {
            Integer acctId = doctor.getAcctId();
            HashMap<String, Long> map = new HashMap<>();
            map.put("id",id.longValue());
            map.put("modifyId",modifyId);
            doctorMapper.updateDeleteByPrimaryKey(map);
            HashMap<String, Long> acctMap = new HashMap<>();
            acctMap.put("modifyId",modifyId);
            acctMap.put("acctId",acctId.longValue());
            accountInfoDetailMapper.updateDeleteByPrimaryKey(acctMap);
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_NOT_REGISTER);
        }
    }

    /**
     * 客服管理后台添加医生
     * 1)当前医生信息是否存在,如果已经存在直接抛出异常；
     * 2)账户表和医生表；
     * 3)手机号进行加密存储；
     * 4)账户基本信息的处理:姓名,性别,年龄,生日,身份证号；
     *
     * @param doctor 新的医生数据
     */
    @Override
    @Transactional
    public Integer addDoctorInfo(Doctor doctor,Long doctorId) {
        String mobilePhone = doctor.getMobilePhone();
        String mobileEncrypt = AESUtil.encryptV0(mobilePhone);
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(mobileEncrypt);
        if (accountInfoEntity != null) {
            throw new AccountException(AccountExceptionEnum.PICA_ALREADY_REGISTER);
        }
        String password = doctor.getPassword();
        Date currentTime = new Date();
        AccountInfoEntity entity = new AccountInfoEntity();
        entity.setMobilePhone(mobileEncrypt);
        entity.setPassword(password);
        entity.setCreatedTime(currentTime);
        entity.setModifiedTime(currentTime);
        entity.setModifiedId(doctorId.intValue());
        entity.setRegisterProduct(AccountTypeEnum.PRODUCT_TYPE_DOCTOR.getCode());
        entity.setRegTime(currentTime);
        //客服系统新增医生
        entity.setRegisterSource(AccountTypeEnum.DEVICE_TYPE_ADMIN.getCode());
        entity.setCreatedId(doctorId.intValue());
        entity.setDeleteFlag(1);
        entity.setSex(doctor.getSex());
        entity.setName(doctor.getName());
        entity.setIdCard(doctor.getCard());
        entity.setAge(doctor.getAge());
        entity.setBirthday(doctor.getBirthday());
        accountInfoDetailMapper.insertSelective(entity);
        doctor.setAcctId(entity.getId());
        doctor.setMobilePhone(mobileEncrypt);
        doctor.setModifyId(doctorId.intValue());
        doctor.setCreatId(doctorId.intValue());
        doctor.setCreatTime(currentTime);
        doctor.setModifyTime(new Date());
        doctor.setRegisterSource(AccountTypeEnum.DEVICE_TYPE_ADMIN.getCode());
        doctor.setDeleteFlag(1);
        doctorMapper.insertSelective(doctor);
        return doctor.getId();
    }

    @Override
    @Transactional
    public void bindWeChat(int acctId, String unionId) {
        doctorMapper.bindWeChat(acctId, unionId);
    }

    @Override
    @Transactional
    public void unbindWeChat(int acctId) {
        doctorMapper.unbindWeChat(acctId);
    }
}
