package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created on 2020/1/20 15:03
 * author:crs
 * Description:性能测试需要
 */
@Api(description = "性能测试接口")
@RequestMapping("/function")
@RestController
public class TestMobileController {

    @GetMapping("/encry")
    public PicaResponse getEncryMobile(String mobile) {
        if (StringUtils.isNotEmpty(mobile)) {
            return PicaResponse.toResponse(AESUtil.encryptV0(mobile));
        } else {
            return PicaResponse.toResponse(null, "数据为空");
        }
    }
}
