package com.pica.cloud.account.account.client;

import com.pica.cloud.account.account.common.dto.AccountWeChatInfoDto;
import com.pica.cloud.account.account.common.req.AccountInfoReq;
import com.pica.cloud.account.account.common.resp.DoctorUnionResp;
import com.pica.cloud.foundation.entity.PicaResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author andong
 * @create 2019/7/19
 */
@FeignClient(name = "13201-pica-cloud-account")
public interface AccountInfoClient {

    @PostMapping("/account/info/count")
    PicaResponse<Integer> getCount(@RequestBody AccountInfoReq req);

    @PostMapping("/account/info/doctorIds")
    PicaResponse<List<Integer>> getDoctorIds(@RequestBody AccountInfoReq req);

    @GetMapping(value = "/account/token/continue")
    PicaResponse<String> tokenContinueTime(@RequestHeader(value = "token") String token,
                                           @RequestHeader(value = "sourceType") Integer sourceType,
                                           @RequestParam(value = "seconds", required = false) Integer seconds);

    @PostMapping("/account/info/wechat/batch")
    PicaResponse<Map<Integer,String>> getWechatInfoBatch(@RequestBody List<Integer> docIds);

    @GetMapping("/account/info/wechat/info")
    PicaResponse<AccountWeChatInfoDto> getWechatInfo(@RequestHeader(value = "token") String token);

    @GetMapping(value = "/account/account/innerDoctors")
    PicaResponse<List<Integer>> getDoctorsByInnerOrg();

    @GetMapping(value = "/account/info/doctor/union")
    PicaResponse<DoctorUnionResp> getDoctorByUnionid( @RequestParam(value = "unionid") String unionid);


}
