package com.pica.cloud.account.account.server.controller;


import com.pica.cloud.account.account.server.entity.AccountUser;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.entity.LogLoginEntity;
import com.pica.cloud.account.account.server.enums.EnumsType;
import com.pica.cloud.account.account.server.log.PicaLogUtils;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.LoginService;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

@Api(description = "登录资源")
@RestController
public class LoginController extends AccountBaseController {

    @Autowired
    private LoginService loginService;

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient redisClient;

    @Autowired
    private PicaLogUtils picaLogUtils;

    @Autowired
    private AccountUtils accountUtils;


    /**
     * 密码登录接口
     *
     * @param entity
     * @return
     * @throws Exception
     */
    @ApiOperation("密码登录接口")
    @PostMapping("/login")
    public PicaResponse<String> loginByPassword(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        AccountUtils.checkMobilePhone(request.getMobile());
        AccountUtils.checkPassword(request.getPassword());
        String result = loginService.login(request);
        //todo：查询是否完善过信息
        return PicaResponse.toResponse(result);
    }

    /**
     * 一键登录
     *
     * @param entity
     * @return
     * @throws Exception
     */
    @ApiOperation("一键登录接口")
    @PostMapping(value = "/login-register")
    public PicaResponse loginAndRegister(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        accountUtils.checkMobilePhone(request.getMobile());
        accountUtils.getAuthCodeKey(request.getMobile(), EnumsType.SYSCODE_TYPE_LOGIN.getCode() + "");
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        String json = loginService.loginAndRegister(request);
        return PicaResponse.toResponse(json);
    }

    @ApiOperation("微信登录接口")
    @PostMapping(value = "/login/wechat")
    public PicaResponse loginByWeChat(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        String result = loginService.loginByWeChat(request);
        return PicaResponse.toResponse(result);
    }

    @ApiOperation("微信登录第二步接口")
    @PostMapping(value = "/login/wechat/step2")
    public PicaResponse loginByWeChatStep(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        accountUtils.checkMobilePhone(request.getMobile());
        accountUtils.checkAuthCode(request.getMobile(), EnumsType.SYSCODE_TYPE_WE_CHAT.getCode() + "", request.getSysCode());
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        String result = loginService.loginByWeChatStep(request);
        return PicaResponse.toResponse(result);
    }

    /**
     * 绑定微信接口
     *
     * @param entity
     * @return
     * @throws Exception
     */
    @ApiOperation("绑定微信接口")
    @PostMapping("/login/wechat/bind")
    public PicaResponse<String> bindWeChat(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        String weChatCode = request.getWeChatCode();
        request.setProductType(super.getProductType());
        // TODO: 2019/8/29  绑定微信接口
        return null;
    }

    /**
     * 退出登录接口
     *
     * @return
     */
    @ApiOperation(value = "退出登录接口")
    @GetMapping("/logout")
    public PicaResponse loginOut() {
        //只有在登录状态下才能调用此接口;
        AccountUser accountUser = super.getAccountUser();
        String token = accountUser.getToken();
        if (StringUtils.isNotEmpty(token)) {
            Integer id = accountUser.getAcctId();
            LogLoginEntity entity = new LogLoginEntity();
            entity.setAcctId(id);
            entity.setCreateId(id);
            entity.setCreateTime(new Date());
            entity.setModifyId(id);
            entity.setModifyTime(new Date());
            entity.setDeleteFlag(1);
            entity.setLoginTime(new Date());
            entity.setProductType(super.getProductType());
            entity.setSourceType(super.getSourceType());
            entity.setLoginType(EnumsType.LOGIN_OUT.getCode());
            entity.setLoginIp(super.getIpAddr());
            entity.setLoginStatus(EnumsType.LOGIN_STATUS_SUCCESS.getCode());
            entity.setLogType(EnumsType.LOG_TYPE_LOGIN.getCode());
            picaLogUtils.info(entity);
            if (redisClient.deleteToken(token)) {
                return PicaResponse.toResponse();
            }
        }
        return null;
    }


    @ApiOperation("微信解除绑定接口")
    @PostMapping("/login/wechat/unbind")
    public PicaResponse unbindWeChat(@RequestBody EncryptEntity entity) throws Exception {
        String token = super.getToken();
        if (!StringUtil.isEmpty(redisClient.get(token))) {
            //说明用户登录状态,//联合登录表中
            loginService.unbindWeChat(super.getAcctId());
        }
        return PicaResponse.toResponse();
    }


}
