package com.pica.cloud.account.account.server.service;

import com.pica.cloud.account.account.server.req.BaseRequest;

public interface LoginService {
    /**
     * 密码登录功能
     *
     * @param request
     * @return
     */
    String login(BaseRequest request);

    /**
     * 一键登录功能
     *
     * @param request
     * @return
     */
    String loginAndRegister(BaseRequest request);

    /**
     * 微信登录
     *
     * @param baseRequest
     */
    String loginByWeChat(BaseRequest baseRequest);

    /**
     * 微信登陆第二步
     *
     * @param request
     * @return
     */
    String loginByWeChatStep(BaseRequest request);

    /**
     * 解除绑定
     *
     * @param acctId
     */
    void unbindWeChat(Integer acctId);


}
