package com.pica.cloud.account.account.server.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.*;
import com.pica.cloud.account.account.server.enums.EnumsType;
import com.pica.cloud.account.account.server.enums.ExceptionType;
import com.pica.cloud.account.account.server.log.PicaLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.AccountUserInfoMapper;
import com.pica.cloud.account.account.server.req.AccountReq;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.LoginService;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.TokenUtils;
import com.pica.cloud.account.account.server.util.WeChatUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service
public class LoginServiceImpl implements LoginService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountUserInfoMapper accountUserInfoMapper;

    @Autowired
    private AccountUnionMapper accountUnionMapper;

    @Autowired
    private AccountWeChatInfoMapper accountWeChatInfoMapper;

    @Autowired
    private PicaLogUtils picaLogUtils;

    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    private RegisterService registerService;

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient redisClient;

    @Value("${weChatAppID}")
    private String appId;
    @Value("${weChatAppSecret}")
    private String appSecret;
    @Value("${weChatURL}")
    private String weChatURL;

    @Override
    public String login(BaseRequest request) {
        String mobile = request.getMobile();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(mobile));
        if (accountInfoEntity != null) {
            String oldPwd = accountInfoEntity.getPassword();
            String password = request.getPassword();
            if (password.equals(EncryptCreateUtil.dencrypt(oldPwd))) {
                //登陆成功，返回新的token
                //通过账户id查询用户id
                Date currentTime = new Date();
                Integer acctId = accountInfoEntity.getId();
                AccountUserInfoEntity accountUserInfoEntity = accountUserInfoMapper.selectByAcctId(acctId);
                int productType = request.getProductType();
                int sourceType = request.getSourceType();
                Account account = new Account();
                account.setId(accountUserInfoEntity.getId().longValue());
                account.setAcctId(acctId);
                account.setCreatTime(currentTime);
                account.setMobilePhone(mobile);
                account.setRegisterSource(sourceType);
                String newToken = tokenUtils.generateToken(account);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("token", newToken);
                jsonObject.put("userId", accountUserInfoEntity.getId().longValue());
                LogLoginEntity entity = new LogLoginEntity();
                entity.setAcctId(acctId);
                entity.setCreateId(acctId);
                entity.setCreateTime(currentTime);
                entity.setModifyId(acctId);
                entity.setModifyTime(currentTime);
                entity.setDeleteFlag(1);
                entity.setLoginTime(currentTime);
                entity.setProductType(productType);
                entity.setSourceType(request.getSourceType());
                entity.setLoginType(EnumsType.LOGIN_REGISTER.getCode());
                entity.setLoginIp(request.getLoginIp());
                entity.setLoginStatus(EnumsType.LOGIN_STATUS_SUCCESS.getCode());
                entity.setLogType(EnumsType.LOG_TYPE_LOGIN.getCode());
                picaLogUtils.info(entity);
                return jsonObject.toJSONString();
            } else {
                logger.info("login failure：" + mobile);
                throw new PicaException(ExceptionType.PICA_PASSWORD_ERROR.getCode(), ExceptionType.PICA_PASSWORD_ERROR.getMessage());
            }
        } else {
            throw new PicaException(ExceptionType.PICA_NOT_REGISTER.getCode(), ExceptionType.PICA_NOT_REGISTER.getMessage());
        }
    }


    @Override
    public String loginAndRegister(BaseRequest baseRequest) {
        String mobile = baseRequest.getMobile();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(mobile));
        if (accountInfoEntity == null) {
            return registerService.register(baseRequest);
        } else {
            return processLogin(baseRequest, accountInfoEntity.getId());
        }
    }

    /**
     * 登录逻辑处理
     *
     * @param baseRequest
     */
    private String processLogin(BaseRequest baseRequest, Integer acctId) {
        Date currentTime = new Date();
        AccountUserInfoEntity accountUserInfoEntity = accountUserInfoMapper.selectByAcctId(acctId);
        //验证码登陆：只要相同即可成功
        AccountReq accountReq = new AccountReq();
        accountReq.setAuthCode(baseRequest.getSysCode());
        accountReq.setMobilePhone(baseRequest.getMobile());
        accountReq.setFlag("0");
        checkAuthCode(accountReq);
        Account account = new Account();
        account.setId(accountUserInfoEntity.getId().longValue());
        account.setAcctId(acctId);
        account.setCreatTime(currentTime);
        account.setMobilePhone(baseRequest.getMobile());
        account.setRegisterSource(baseRequest.getSourceType());
        String newToken = tokenUtils.generateToken(account);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("token", newToken);
        jsonObject.put("userId", accountUserInfoEntity.getId().longValue());
        LogLoginEntity entity = new LogLoginEntity();
        entity.setAcctId(acctId);
        entity.setCreateId(acctId);
        entity.setCreateTime(currentTime);
        entity.setModifyId(acctId);
        entity.setModifyTime(currentTime);
        entity.setDeleteFlag(1);
        entity.setLoginTime(currentTime);
        entity.setProductType(baseRequest.getProductType());
        entity.setSourceType(baseRequest.getSourceType());
        entity.setLoginType(EnumsType.LOGIN_REGISTER.getCode());
        entity.setLoginIp(baseRequest.getLoginIp());
        entity.setLoginStatus(EnumsType.LOGIN_STATUS_SUCCESS.getCode());
        entity.setLogType(EnumsType.LOG_TYPE_LOGIN.getCode());
        picaLogUtils.info(entity);
        return jsonObject.toJSONString();
    }

    @Override
    public String loginByWeChat(BaseRequest request) {
        WeChatEntity weChatEntity = WeChatUtils.getAuthorizationInfo(appId, appSecret, request.getWeChatCode());
        //todo：微信登录获取个人信息

        Map map = new HashMap();
        map.put("access_token", weChatEntity.getAccess_token());
        map.put("openid", weChatEntity.getOpenid());

        Map weChatUserInfo = WeChatUtils.getWeChatUserInfo(map, weChatURL);
        WeChatUserInfoEntity weChatUserInfoEntity = WeChatUtils.mergeWechatUserInfo(weChatUserInfo, weChatEntity.getOpenid());
        String unionId = weChatUserInfoEntity.getUnionid();
        AccountUnionEntity accountUnionEntity = accountUnionMapper.selectByUnionId(unionId);
        if (accountUnionEntity != null) {
            //是否绑定逻辑的判断
            Long acctId = accountUnionEntity.getAcctId();
            AccountUserInfoEntity accountUserInfoEntity = accountUserInfoMapper.selectByAcctId(acctId.intValue());
            Account account = new Account();
            account.setId(accountUserInfoEntity.getId().longValue());
            account.setAcctId(acctId.intValue());
            account.setCreatTime(new Date());
            account.setMobilePhone(request.getMobile());
            account.setRegisterSource(request.getSourceType());
            String newToken = tokenUtils.generateToken(account);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("token", newToken);
            jsonObject.put("userId", accountUserInfoEntity.getId().longValue());
            jsonObject.put("bindFlag", EnumsType.BIND_STATUS_SUCCESS.getCode());
            return jsonObject.toJSONString();
        } else {
            AccountWeChatInfoEntity entity = accountWeChatInfoMapper.selectByUnionId(unionId);
            if (entity == null) {
                Date currentTime = new Date();
                AccountWeChatInfoEntity accountWeChatInfoEntity = new AccountWeChatInfoEntity();
                accountWeChatInfoEntity.setCreatedId(0);
                accountWeChatInfoEntity.setCreatedTime(currentTime);
                accountWeChatInfoEntity.setDeleteFlag(1);
                accountWeChatInfoEntity.setGroupid(weChatUserInfoEntity.getGroupid() + "");
                accountWeChatInfoEntity.setType(request.getWeChatLoginType());
                accountWeChatInfoEntity.setModifiedId(0);
                accountWeChatInfoEntity.setModifiedTime(currentTime);
                accountWeChatInfoEntity.setOpenid(weChatUserInfoEntity.getOpenid());
                accountWeChatInfoEntity.setUnionid(weChatUserInfoEntity.getUnionid());
                accountWeChatInfoEntity.setPrivilege(weChatUserInfoEntity.getPrivilege());
                accountWeChatInfoEntity.setRemark(weChatUserInfoEntity.getRemark());
                accountWeChatInfoEntity.setSubscribe(weChatUserInfoEntity.getSubscribe());
                accountWeChatInfoEntity.setSubscribeTime(weChatUserInfoEntity.getSubscribe_time());
                accountWeChatInfoEntity.setTagidList(weChatUserInfoEntity.getTagid_list());
                accountWeChatInfoMapper.insertSelective(accountWeChatInfoEntity);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("bindFlag", EnumsType.BIND_STATUS_FAILURE.getCode());
            jsonObject.put("unionId", unionId);
            return jsonObject.toJSONString();
        }
    }

    @Override
    public String loginByWeChatStep(BaseRequest request) {
        //判断当前手机号是否注册过,注册过，直接登录；没有注册过，进行注册操操作
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(request.getMobile()));
        String json;
        if (accountInfoEntity == null) {
            json = registerService.register(request);
        } else {
            json = processLogin(request, accountInfoEntity.getId());
        }



        //向表中插入数据
        //todo：向联合登录表插入信息，信息哪里来？

        return json;
    }

    @Override
    public void unbindWeChat(Integer acctId) {
        accountUnionMapper.updateUnbindByAcctId(acctId);
    }

    //校验验证码
    private void checkAuthCode(AccountReq req) {
        String flag = StringUtils.isBlank(req.getFlag()) ? "0" : req.getFlag();

        if (StringUtils.isBlank(req.getAuthCode())) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }

        String authCodeKey = AccountUtils.getAuthCodeKey(req.getMobilePhone(), flag);
        String cacheCode = redisClient.get(authCodeKey);  //从redis获取验证码
        if (StringUtils.isBlank(cacheCode)) {
            throw new PicaException(PicaResultCode.RESULE_DATA_NONE.code(), "短信验证码已过期，请重新获取");
        }
        if (!StringUtils.equals(req.getAuthCode(), cacheCode)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }
        redisClient.del(authCodeKey);  //清除验证码
    }

}
