package com.pica.cloud.account.account.client;

import com.pica.cloud.account.account.common.req.AcctPatFamilyReq;
import com.pica.cloud.account.account.common.req.AcctPatInfoReq;
import com.pica.cloud.account.account.common.resp.PatBindResp;
import com.pica.cloud.account.account.common.resp.PatFamilyResp;
import com.pica.cloud.foundation.entity.PicaResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


@FeignClient(name = "13201-pica-cloud-account")
public interface PatHealthPackClient {

    @GetMapping(value = "/account/pat-health/acctId/unionId/{unionId}")
    PicaResponse<Integer> getAcctIdByUnionId(@PathVariable("unionId") String unionId);

    @GetMapping(value = "/account/pat-health/acctId/patId/{patientId}")
    PicaResponse<Integer> getAcctIdByPatId(@PathVariable("patientId") Integer patientId);

    @GetMapping(value = "/account/pat-health/directPatIds/{patientId}")
    PicaResponse<List<Integer>> getDirectPatIdsByPatId(@PathVariable("patientId") Integer patientId);

    @GetMapping(value = "/account/pat-health/familyPats/{acctId}")
    PicaResponse<PatFamilyResp> getFamilyPatsByAcctId(@PathVariable("acctId") Integer acctId);

    @PostMapping(value = "/account/pat-health/acct")
    PicaResponse saveAcct(@RequestBody AcctPatInfoReq patInfoReq);

    @PostMapping(value = "/account/pat-health/acct/bindUnion")
    PicaResponse<PatBindResp> bindUnion(@RequestBody AcctPatInfoReq patInfoReq);

    @PostMapping(value = "/account/pat-health/family/member")
    PicaResponse saveMember(@RequestBody AcctPatFamilyReq familyReqReq);

}
