package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.service.CaptchaService;
import com.pica.cloud.account.account.server.util.captcha.CaptchaToken;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author andong
 * @create 2019/8/9
 */
@Api(description = "图形验证码")
@RestController
@RequestMapping("/account")
public class CaptchaController {

    @Autowired
    private CaptchaService captchaService;

    @ApiOperation("获取图形验证码")
    @GetMapping("/captcha")
    public PicaResponse<CaptchaToken> captcha(@ApiParam("图片宽度") @RequestParam(value = "width", required = false) Integer width,
                                              @ApiParam("图片高度") @RequestParam(value = "height", required = false) Integer height) {
        width = (width == null || width.intValue() <= 0) ? 160 : width;
        height = (height == null || height.intValue() <= 0) ? 40 : height;
        CaptchaToken captchaToken = captchaService.generateToken(width, height);
        return PicaResponse.toResponse(captchaToken);
    }


    @ApiOperation("校验图形验证码")
    @GetMapping("/acknowledge")
    public PicaResponse<Boolean> acknowledge(@ApiParam("captchaToken") @RequestParam("captchaToken") String captchaToken,
                                             @ApiParam("captchaAnswer") @RequestParam("captchaAnswer") String captchaAnswer) {
        boolean valid = captchaService.acknowledge(captchaToken, captchaAnswer);
        return PicaResponse.toResponse(valid);
    }


}
