package com.pica.cloud.clickhouse.clickhouse.client.service;


import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "13301-pica-cloud-clickhouse")
public interface CrashControllerService {


    @RequestMapping(value = "/clickhouse/crash/cartoon", method = RequestMethod.GET)
    PicaResponse getCartoon();


    @RequestMapping(value = "/clickhouse/crash/init",method = RequestMethod.GET)
    public PicaResponse init();

    @ApiOperation(value = "页面查看次数", response = PicaResponse.class)
    @RequestMapping(value = "/clickhouse/crash/countOnPage",method = RequestMethod.GET)
    public PicaResponse countOnPage(@RequestParam(name = "begin", required = true) String begin, @RequestParam(name = "end", required = true) String end);

    @ApiOperation(value = "音频播放次数", response = PicaResponse.class)
    @RequestMapping(value = "/clickhouse/crash/countMusic",method = RequestMethod.GET)
    public PicaResponse countMusic(@RequestParam(name = "begin", required = true) String begin,@RequestParam(name = "end", required = true) String end);

    }
