package com.pica.cloud.clickhouse.clickhouse.server.configuration;

import com.pica.cloud.foundation.redis.CacheMigrateClient;
import com.pica.cloud.foundation.redis.ICacheClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@RefreshScope
public class RedisClientConfiguration {

    @Autowired
    private SpringContextAware springContextAware;

    @Bean
    @ConditionalOnMissingBean
    public ICacheClient cacheClient() {
        return new CacheMigrateClient(springContextAware.getActiveProfile());
    }
}
