package com.pica.cloud.clickhouse.clickhouse.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.foundation.clickhouse.service.ClickHouseService;
import com.pica.cloud.foundation.clickhouse.service.config.TableEnum;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.utils.controller.BaseController;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/crash")
@Api(value = "打点数据 ")
public class CrashController extends BaseController {

    @Autowired
    private ClickHouseService clickHouseService;

    @ApiOperation(value = "", response = PicaResponse.class)
    @RequestMapping(value = "/cartoon",method = RequestMethod.GET)
    public PicaResponse getCartoon(){
        //String sql ="SELECT count(1), subString(web_data,1,16) FROM trace_app   where web_data_type='1' and extra_info='com.picahealth.patient'  and web_data like 'eduComId=%' group by subString(web_data,1,16)";

        List<com.alibaba.fastjson.JSONObject> res = clickHouseService.queryPatientOpens();

        return PicaResponse.toResponse(res);
    }

    @ApiOperation(value = "init data", response = PicaResponse.class)
    @RequestMapping(value = "/init",method = RequestMethod.GET)
    public PicaResponse init(@RequestParam(name = "begin", required = true) String begin,@RequestParam(name = "end", required = true) String end){
        PicaResponse.Builder builder =  new PicaResponse.Builder();
        if(StringUtil.isEmpty(begin) || StringUtil.isEmpty(end)){
            return builder.setData(null).setCode(PicaResultCode.PARAM_IS_BLANK.code()).setMessage(PicaResultCode.PARAM_IS_BLANK.message()).build();
        }
        if(  StringUtil.isNotNull(begin) &&  StringUtil.isNotNull(end) ){
            if( begin.length()!=10 || ( !begin.contains("-")) || end.length()!=10 || ( !end.contains("-")) ){
                return builder.setData(null).setCode(PicaResultCode.PARAM_IS_INVALID.code()).setMessage(PicaResultCode.PARAM_IS_INVALID.message()+",please use like '2019-05-03' ").build();
            }
        }
        String sql ="select distinct web_data,doctor_id,view_path,class_name,pseudo_session,action,created from trace_app where action='ACTION_WEB_ENTER' and class_name like '%healthNotice%' and web_data like '%eduComId%' " ;
        sql = sql + " and  created_day >= '";
        sql = sql + begin ;
        sql = sql + "' and  created_day <= '";
        sql = sql + end ;
        sql = sql +   "' order by created desc ";
        List<com.alibaba.fastjson.JSONObject> res = clickHouseService.query(sql, TableEnum.traceappp);

        String sql2 ="select distinct web_data ,doctor_id,view_path,class_name,pseudo_session,action,created from trace_app where action='ACTION_WEB_ENTER' and class_name like '%messageTemp%'  " ;
        sql2 = sql2 + " and  created_day >= '";
        sql2 = sql2 + begin ;
        sql2 = sql2 + "' and  created_day <= '";
        sql2 = sql2 + end ;
        sql2 = sql2 + "' order by created desc ";
        List<com.alibaba.fastjson.JSONObject> res2 = clickHouseService.query(sql2, TableEnum.traceappp);

        Map<String,List> map = new HashMap<String,List>();
        map.put("healthNotice",res);
        map.put("messageTemp",res2);
        return builder.setData(map).build();
    }

    @ApiOperation(value = "页面查看次数", response = PicaResponse.class)
    @RequestMapping(value = "/countOnPage",method = RequestMethod.GET)
    public PicaResponse countOnPage(@RequestParam(name = "begin", required = true) String begin,@RequestParam(name = "end", required = true) String end){
        PicaResponse.Builder builder =  new PicaResponse.Builder();
        if(StringUtil.isEmpty(begin) || StringUtil.isEmpty(end)){
            return builder.setData(null).setCode(PicaResultCode.PARAM_IS_BLANK.code()).setMessage(PicaResultCode.PARAM_IS_BLANK.message()).build();
        }
        if(  StringUtil.isNotNull(begin) &&  StringUtil.isNotNull(end) ){
            if( begin.length()!=10 || ( !begin.contains("-")) || end.length()!=10 || ( !end.contains("-")) ){
                return builder.setData(null).setCode(PicaResultCode.PARAM_IS_INVALID.code()).setMessage(PicaResultCode.PARAM_IS_INVALID.message()+",please use like '2019-05-03' ").build();
            }
        }
        String sql ="select distinct web_data from trace_app where action='ACTION_WEB_ENTER' and view_path like '%healthNotice%' and web_data like '%eduComId%' " ;
         sql = sql + " and  created_day >= '";
         sql = sql + begin ;
         sql = sql + "' and  created_day <= '";
         sql = sql + end ;
         sql = sql +   "' order by created desc ";
        List<com.alibaba.fastjson.JSONObject> res = clickHouseService.query(sql, TableEnum.traceappp);

        String sql2 ="select distinct web_data from trace_app where action='ACTION_WEB_ENTER' and view_path like '%messageTemp%'  " ;
        sql2 = sql2 + " and  created_day >= '";
        sql2 = sql2 + begin ;
        sql2 = sql2 + "' and  created_day <= '";
        sql2 = sql2 + end ;
        sql2 = sql2 + "' order by created desc ";
        List<com.alibaba.fastjson.JSONObject> res2 = clickHouseService.query(sql2, TableEnum.traceappp);

        Map<String,List> map = new HashMap<String,List>();
        map.put("healthNotice",res);
        map.put("messageTemp",res2);
        return builder.setData(map).build();
    }

    @ApiOperation(value = "音频播放次数", response = PicaResponse.class)
    @RequestMapping(value = "/countMusic",method = RequestMethod.GET)
    public PicaResponse countMusic(@RequestParam(name = "begin", required = true) String begin,@RequestParam(name = "end", required = true) String end){
        PicaResponse.Builder builder =  new PicaResponse.Builder();
        if(StringUtil.isEmpty(begin) || StringUtil.isEmpty(end)){
            return builder.setData(null).setCode(PicaResultCode.PARAM_IS_BLANK.code()).setMessage(PicaResultCode.PARAM_IS_BLANK.message()).build();
        }
        if(  StringUtil.isNotNull(begin) &&  StringUtil.isNotNull(end) ){
            if( begin.length()!=10 || ( !begin.contains("-")) || end.length()!=10 || ( !end.contains("-")) ){
                return builder.setData(null).setCode(PicaResultCode.PARAM_IS_INVALID.code()).setMessage(PicaResultCode.PARAM_IS_INVALID.message()+",please use like '2019-05-03' ").build();
            }
        }
        String sql ="select distinct web_data from trace_app where view_path like '%healthNotice%' and web_data like '%eduComId%' " ;
        sql = sql + " and  created_day >= '";
        sql = sql + begin ;
        sql = sql + "' and  created_day <= '";
        sql = sql + end ;
        sql = sql +   "' order by created desc ";
        List<com.alibaba.fastjson.JSONObject> list = clickHouseService.query(sql, TableEnum.traceappp);
        List<com.alibaba.fastjson.JSONObject> extra = new ArrayList<>();
        for (JSONObject jsonObject:
             list) {
            String webData = jsonObject.get("web_data")==null ? "" : jsonObject.get("web_data").toString() ;
            if(StringUtil.isNotNull(webData)){
                String[] vlues = webData.split(";");
                for (String v: vlues) {
                    String[] vs = v.split("=" );
                    if(vs.length>1){
                        if(vs[0].equals("audioId") && ( "0".equals(vs[1]) || "".equals(vs[1])) ){
                            extra.add(jsonObject);
                        }
                        if(vs[0].equals("audioStatus") && ( !"1".equals(vs[1]) ) ){
                            extra.add(jsonObject);
                        }
                    }
                    if (vs.length==1){
                        if(vs[0].equals("audioId")  ){
                            extra.add(jsonObject);
                        }

                        if(vs[0].equals("audioStatus")  ){
                            extra.add(jsonObject);
                        }
                    }
                }
            }
        }
        list.removeAll(extra);
        return builder.setData(list).build();
    }

    public static void main(String[] args){
        String value ="eduComId=1;doctorId=101322314;pathParam=doctorId=101322314&patientId=&smsId=710947&eduComId=1&batchNo=10-0dd80ebfd3ca41f5b1abba398b2348ff&templetType=healthNotice&type=3&audioId=10370&code=011w6XGe2WYT6I0yqgJe2vcfHe2w6XGV&state=;templetType=healthNotice;smsEntityId=710947;batchNo=10-0dd80ebfd3ca41f5b1abba398b2348ff;audioId=1;type=3;audioStatus=1;";
        String[] vlues = value.split(";");
        for (String v: vlues) {
            String[] vs = v.split("=" );
            if(vs.length>1){
                if(vs[0].equals("audioId") && ( "0".equals(vs[1]) || "".equals(vs[1])) ){
                    //去掉
                    System.out.println("2去掉audioId");
                }
                if(vs[0].equals("audioStatus") && ( !"1".equals(vs[1]) ) ){
                    //去掉
                    System.out.println("2去掉audioStatus");
                }
            }
            if (vs.length==1){
                if(vs[0].equals("audioId")  ){
                    //去掉
                    System.out.println("1去掉audioId ");
                }
                if(vs[0].equals("audioStatus")  ){
                    //去掉
                    System.out.println("1去掉audioStatus");
                }
            }
        }

    }








}
