package com.pica.cloud.clickhouse.clickhouse.server.controller;

import com.pica.cloud.foundation.clickhouse.service.ClickHouseService;
import com.pica.cloud.foundation.clickhouse.service.config.TableEnum;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.utils.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/crash")
@Api(value = "打点数据 ")
public class CrashController extends BaseController {

    @Autowired
    private ClickHouseService clickHouseService;

    @ApiOperation(value = "", response = PicaResponse.class)
    @RequestMapping(value = "/cartoon",method = RequestMethod.GET)
    public PicaResponse getCartoon(){
        //String sql ="SELECT count(1), subString(web_data,1,16) FROM trace_app   where web_data_type='1' and extra_info='com.picahealth.patient'  and web_data like 'eduComId=%' group by subString(web_data,1,16)";

        List<com.alibaba.fastjson.JSONObject> res = clickHouseService.queryPatientOpens();

        return PicaResponse.toResponse(res);
    }

    @ApiOperation(value = "init data", response = PicaResponse.class)
    @RequestMapping(value = "/init",method = RequestMethod.GET)
    public PicaResponse init(){
        String sql ="select doctor_id,web_data,view_path,class_name,pseudo_session,pseudo_id,action,created from trace_app where action='ACTION_WEB_ENTER' and view_path like '%healthNotice%' and web_data like '%eduComId%' order by created desc ";
        List<com.alibaba.fastjson.JSONObject> res = clickHouseService.query(sql, TableEnum.traceappp);

        String sql2 ="select doctor_id,web_data,view_path,class_name,pseudo_session,pseudo_id,action,created from trace_app where action='ACTION_WEB_ENTER' and view_path like '%messageTemp%' and web_data like '%eduComId%' order by created desc ";
        List<com.alibaba.fastjson.JSONObject> res2 = clickHouseService.query(sql2, TableEnum.traceappp);

        Map<String,List> map = new HashMap<String,List>();
        map.put("healthNotice",res);
        map.put("messageTemp",res2);
        return PicaResponse.toResponse(map);
    }

    @ApiOperation(value = "页面查看次数", response = PicaResponse.class)
    @RequestMapping(value = "/countOnPage",method = RequestMethod.GET)
    public PicaResponse countOnPage(@RequestParam(name = "begin", required = true) String begin,@RequestParam(name = "end", required = true) String end){
        String sql ="select web_data from trace_app where action='ACTION_WEB_ENTER' and view_path like '%healthNotice%' and web_data like '%eduComId%' " ;
         sql = sql + " and  created_day >= ";
         sql = sql + begin ;
         sql = sql + " and  created_day <= ";
         sql = sql + end ;
         sql = sql +   " order by created desc ";
        List<com.alibaba.fastjson.JSONObject> res = clickHouseService.query(sql, TableEnum.traceappp);

        String sql2 ="select web_data from trace_app where action='ACTION_WEB_ENTER' and view_path like '%messageTemp%' and web_data like '%eduComId%' " ;
        sql2 = sql2 + " and  created_day >= ";
        sql2 = sql2 + begin ;
        sql2 = sql2 + " and  created_day <= ";
        sql2 = sql2 + end ;
        sql2 = sql2 + " order by created desc ";
        List<com.alibaba.fastjson.JSONObject> res2 = clickHouseService.query(sql2, TableEnum.traceappp);

        Map<String,List> map = new HashMap<String,List>();
        map.put("healthNotice",res);
        map.put("messageTemp",res2);
        return PicaResponse.toResponse(map);
    }








}
